/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for certain <code>Config</code> object types in a contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigDetails implements SdkPojo, Serializable, ToCopyableBuilder<ConfigDetails.Builder, ConfigDetails> {
    private static final SdkField<AntennaDemodDecodeDetails> ANTENNA_DEMOD_DECODE_DETAILS_FIELD = SdkField
            .<AntennaDemodDecodeDetails> builder(MarshallingType.SDK_POJO).memberName("antennaDemodDecodeDetails")
            .getter(getter(ConfigDetails::antennaDemodDecodeDetails)).setter(setter(Builder::antennaDemodDecodeDetails))
            .constructor(AntennaDemodDecodeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antennaDemodDecodeDetails").build())
            .build();

    private static final SdkField<EndpointDetails> ENDPOINT_DETAILS_FIELD = SdkField
            .<EndpointDetails> builder(MarshallingType.SDK_POJO).memberName("endpointDetails")
            .getter(getter(ConfigDetails::endpointDetails)).setter(setter(Builder::endpointDetails))
            .constructor(EndpointDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointDetails").build()).build();

    private static final SdkField<S3RecordingDetails> S3_RECORDING_DETAILS_FIELD = SdkField
            .<S3RecordingDetails> builder(MarshallingType.SDK_POJO).memberName("s3RecordingDetails")
            .getter(getter(ConfigDetails::s3RecordingDetails)).setter(setter(Builder::s3RecordingDetails))
            .constructor(S3RecordingDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3RecordingDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ANTENNA_DEMOD_DECODE_DETAILS_FIELD, ENDPOINT_DETAILS_FIELD, S3_RECORDING_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AntennaDemodDecodeDetails antennaDemodDecodeDetails;

    private final EndpointDetails endpointDetails;

    private final S3RecordingDetails s3RecordingDetails;

    private final Type type;

    private ConfigDetails(BuilderImpl builder) {
        this.antennaDemodDecodeDetails = builder.antennaDemodDecodeDetails;
        this.endpointDetails = builder.endpointDetails;
        this.s3RecordingDetails = builder.s3RecordingDetails;
        this.type = builder.type;
    }

    /**
     * <p>
     * Details for antenna demod decode <code>Config</code> in a contact.
     * </p>
     * 
     * @return Details for antenna demod decode <code>Config</code> in a contact.
     */
    public final AntennaDemodDecodeDetails antennaDemodDecodeDetails() {
        return antennaDemodDecodeDetails;
    }

    /**
     * Returns the value of the EndpointDetails property for this object.
     * 
     * @return The value of the EndpointDetails property for this object.
     */
    public final EndpointDetails endpointDetails() {
        return endpointDetails;
    }

    /**
     * <p>
     * Details for an S3 recording <code>Config</code> in a contact.
     * </p>
     * 
     * @return Details for an S3 recording <code>Config</code> in a contact.
     */
    public final S3RecordingDetails s3RecordingDetails() {
        return s3RecordingDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(antennaDemodDecodeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(endpointDetails());
        hashCode = 31 * hashCode + Objects.hashCode(s3RecordingDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigDetails)) {
            return false;
        }
        ConfigDetails other = (ConfigDetails) obj;
        return Objects.equals(antennaDemodDecodeDetails(), other.antennaDemodDecodeDetails())
                && Objects.equals(endpointDetails(), other.endpointDetails())
                && Objects.equals(s3RecordingDetails(), other.s3RecordingDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigDetails").add("AntennaDemodDecodeDetails", antennaDemodDecodeDetails())
                .add("EndpointDetails", endpointDetails()).add("S3RecordingDetails", s3RecordingDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "antennaDemodDecodeDetails":
            return Optional.ofNullable(clazz.cast(antennaDemodDecodeDetails()));
        case "endpointDetails":
            return Optional.ofNullable(clazz.cast(endpointDetails()));
        case "s3RecordingDetails":
            return Optional.ofNullable(clazz.cast(s3RecordingDetails()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #antennaDemodDecodeDetails()} initialized to the given value.
     *
     * <p>
     * Details for antenna demod decode <code>Config</code> in a contact.
     * </p>
     * 
     * @param antennaDemodDecodeDetails
     *        Details for antenna demod decode <code>Config</code> in a contact.
     */
    public static ConfigDetails fromAntennaDemodDecodeDetails(AntennaDemodDecodeDetails antennaDemodDecodeDetails) {
        return builder().antennaDemodDecodeDetails(antennaDemodDecodeDetails).build();
    }

    /**
     * Create an instance of this class with {@link #antennaDemodDecodeDetails()} initialized to the given value.
     *
     * <p>
     * Details for antenna demod decode <code>Config</code> in a contact.
     * </p>
     * 
     * @param antennaDemodDecodeDetails
     *        Details for antenna demod decode <code>Config</code> in a contact.
     */
    public static ConfigDetails fromAntennaDemodDecodeDetails(
            Consumer<AntennaDemodDecodeDetails.Builder> antennaDemodDecodeDetails) {
        AntennaDemodDecodeDetails.Builder builder = AntennaDemodDecodeDetails.builder();
        antennaDemodDecodeDetails.accept(builder);
        return fromAntennaDemodDecodeDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #endpointDetails()} initialized to the given value.
     *
     * Sets the value of the EndpointDetails property for this object.
     *
     * @param endpointDetails
     *        The new value for the EndpointDetails property for this object.
     */
    public static ConfigDetails fromEndpointDetails(EndpointDetails endpointDetails) {
        return builder().endpointDetails(endpointDetails).build();
    }

    /**
     * Create an instance of this class with {@link #endpointDetails()} initialized to the given value.
     *
     * Sets the value of the EndpointDetails property for this object.
     *
     * @param endpointDetails
     *        The new value for the EndpointDetails property for this object.
     */
    public static ConfigDetails fromEndpointDetails(Consumer<EndpointDetails.Builder> endpointDetails) {
        EndpointDetails.Builder builder = EndpointDetails.builder();
        endpointDetails.accept(builder);
        return fromEndpointDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #s3RecordingDetails()} initialized to the given value.
     *
     * <p>
     * Details for an S3 recording <code>Config</code> in a contact.
     * </p>
     * 
     * @param s3RecordingDetails
     *        Details for an S3 recording <code>Config</code> in a contact.
     */
    public static ConfigDetails fromS3RecordingDetails(S3RecordingDetails s3RecordingDetails) {
        return builder().s3RecordingDetails(s3RecordingDetails).build();
    }

    /**
     * Create an instance of this class with {@link #s3RecordingDetails()} initialized to the given value.
     *
     * <p>
     * Details for an S3 recording <code>Config</code> in a contact.
     * </p>
     * 
     * @param s3RecordingDetails
     *        Details for an S3 recording <code>Config</code> in a contact.
     */
    public static ConfigDetails fromS3RecordingDetails(Consumer<S3RecordingDetails.Builder> s3RecordingDetails) {
        S3RecordingDetails.Builder builder = S3RecordingDetails.builder();
        s3RecordingDetails.accept(builder);
        return fromS3RecordingDetails(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigDetails, T> g) {
        return obj -> g.apply((ConfigDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigDetails> {
        /**
         * <p>
         * Details for antenna demod decode <code>Config</code> in a contact.
         * </p>
         * 
         * @param antennaDemodDecodeDetails
         *        Details for antenna demod decode <code>Config</code> in a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder antennaDemodDecodeDetails(AntennaDemodDecodeDetails antennaDemodDecodeDetails);

        /**
         * <p>
         * Details for antenna demod decode <code>Config</code> in a contact.
         * </p>
         * This is a convenience method that creates an instance of the {@link AntennaDemodDecodeDetails.Builder}
         * avoiding the need to create one manually via {@link AntennaDemodDecodeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AntennaDemodDecodeDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #antennaDemodDecodeDetails(AntennaDemodDecodeDetails)}.
         * 
         * @param antennaDemodDecodeDetails
         *        a consumer that will call methods on {@link AntennaDemodDecodeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #antennaDemodDecodeDetails(AntennaDemodDecodeDetails)
         */
        default Builder antennaDemodDecodeDetails(Consumer<AntennaDemodDecodeDetails.Builder> antennaDemodDecodeDetails) {
            return antennaDemodDecodeDetails(AntennaDemodDecodeDetails.builder().applyMutation(antennaDemodDecodeDetails).build());
        }

        /**
         * Sets the value of the EndpointDetails property for this object.
         *
         * @param endpointDetails
         *        The new value for the EndpointDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointDetails(EndpointDetails endpointDetails);

        /**
         * Sets the value of the EndpointDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EndpointDetails.Builder} avoiding the
         * need to create one manually via {@link EndpointDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EndpointDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointDetails(EndpointDetails)}.
         * 
         * @param endpointDetails
         *        a consumer that will call methods on {@link EndpointDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointDetails(EndpointDetails)
         */
        default Builder endpointDetails(Consumer<EndpointDetails.Builder> endpointDetails) {
            return endpointDetails(EndpointDetails.builder().applyMutation(endpointDetails).build());
        }

        /**
         * <p>
         * Details for an S3 recording <code>Config</code> in a contact.
         * </p>
         * 
         * @param s3RecordingDetails
         *        Details for an S3 recording <code>Config</code> in a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3RecordingDetails(S3RecordingDetails s3RecordingDetails);

        /**
         * <p>
         * Details for an S3 recording <code>Config</code> in a contact.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3RecordingDetails.Builder} avoiding the
         * need to create one manually via {@link S3RecordingDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3RecordingDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #s3RecordingDetails(S3RecordingDetails)}.
         * 
         * @param s3RecordingDetails
         *        a consumer that will call methods on {@link S3RecordingDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3RecordingDetails(S3RecordingDetails)
         */
        default Builder s3RecordingDetails(Consumer<S3RecordingDetails.Builder> s3RecordingDetails) {
            return s3RecordingDetails(S3RecordingDetails.builder().applyMutation(s3RecordingDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AntennaDemodDecodeDetails antennaDemodDecodeDetails;

        private EndpointDetails endpointDetails;

        private S3RecordingDetails s3RecordingDetails;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigDetails model) {
            antennaDemodDecodeDetails(model.antennaDemodDecodeDetails);
            endpointDetails(model.endpointDetails);
            s3RecordingDetails(model.s3RecordingDetails);
        }

        public final AntennaDemodDecodeDetails.Builder getAntennaDemodDecodeDetails() {
            return antennaDemodDecodeDetails != null ? antennaDemodDecodeDetails.toBuilder() : null;
        }

        public final void setAntennaDemodDecodeDetails(AntennaDemodDecodeDetails.BuilderImpl antennaDemodDecodeDetails) {
            Object oldValue = this.antennaDemodDecodeDetails;
            this.antennaDemodDecodeDetails = antennaDemodDecodeDetails != null ? antennaDemodDecodeDetails.build() : null;
            handleUnionValueChange(Type.ANTENNA_DEMOD_DECODE_DETAILS, oldValue, this.antennaDemodDecodeDetails);
        }

        @Override
        public final Builder antennaDemodDecodeDetails(AntennaDemodDecodeDetails antennaDemodDecodeDetails) {
            Object oldValue = this.antennaDemodDecodeDetails;
            this.antennaDemodDecodeDetails = antennaDemodDecodeDetails;
            handleUnionValueChange(Type.ANTENNA_DEMOD_DECODE_DETAILS, oldValue, this.antennaDemodDecodeDetails);
            return this;
        }

        public final EndpointDetails.Builder getEndpointDetails() {
            return endpointDetails != null ? endpointDetails.toBuilder() : null;
        }

        public final void setEndpointDetails(EndpointDetails.BuilderImpl endpointDetails) {
            Object oldValue = this.endpointDetails;
            this.endpointDetails = endpointDetails != null ? endpointDetails.build() : null;
            handleUnionValueChange(Type.ENDPOINT_DETAILS, oldValue, this.endpointDetails);
        }

        @Override
        public final Builder endpointDetails(EndpointDetails endpointDetails) {
            Object oldValue = this.endpointDetails;
            this.endpointDetails = endpointDetails;
            handleUnionValueChange(Type.ENDPOINT_DETAILS, oldValue, this.endpointDetails);
            return this;
        }

        public final S3RecordingDetails.Builder getS3RecordingDetails() {
            return s3RecordingDetails != null ? s3RecordingDetails.toBuilder() : null;
        }

        public final void setS3RecordingDetails(S3RecordingDetails.BuilderImpl s3RecordingDetails) {
            Object oldValue = this.s3RecordingDetails;
            this.s3RecordingDetails = s3RecordingDetails != null ? s3RecordingDetails.build() : null;
            handleUnionValueChange(Type.S3_RECORDING_DETAILS, oldValue, this.s3RecordingDetails);
        }

        @Override
        public final Builder s3RecordingDetails(S3RecordingDetails s3RecordingDetails) {
            Object oldValue = this.s3RecordingDetails;
            this.s3RecordingDetails = s3RecordingDetails;
            handleUnionValueChange(Type.S3_RECORDING_DETAILS, oldValue, this.s3RecordingDetails);
            return this;
        }

        @Override
        public ConfigDetails build() {
            return new ConfigDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ConfigDetails#type()
     */
    public enum Type {
        ANTENNA_DEMOD_DECODE_DETAILS,

        ENDPOINT_DETAILS,

        S3_RECORDING_DETAILS,

        UNKNOWN_TO_SDK_VERSION
    }
}
