/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an Lambda function to import to create a component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaFunctionRecipeSource implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaFunctionRecipeSource.Builder, LambdaFunctionRecipeSource> {
    private static final SdkField<String> LAMBDA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lambdaArn").getter(getter(LambdaFunctionRecipeSource::lambdaArn)).setter(setter(Builder::lambdaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaArn").build()).build();

    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentName").getter(getter(LambdaFunctionRecipeSource::componentName))
            .setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()).build();

    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentVersion").getter(getter(LambdaFunctionRecipeSource::componentVersion))
            .setter(setter(Builder::componentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersion").build()).build();

    private static final SdkField<List<ComponentPlatform>> COMPONENT_PLATFORMS_FIELD = SdkField
            .<List<ComponentPlatform>> builder(MarshallingType.LIST)
            .memberName("componentPlatforms")
            .getter(getter(LambdaFunctionRecipeSource::componentPlatforms))
            .setter(setter(Builder::componentPlatforms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentPlatforms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComponentPlatform> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentPlatform::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, ComponentDependencyRequirement>> COMPONENT_DEPENDENCIES_FIELD = SdkField
            .<Map<String, ComponentDependencyRequirement>> builder(MarshallingType.MAP)
            .memberName("componentDependencies")
            .getter(getter(LambdaFunctionRecipeSource::componentDependencies))
            .setter(setter(Builder::componentDependencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentDependencies").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComponentDependencyRequirement> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentDependencyRequirement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<LambdaExecutionParameters> COMPONENT_LAMBDA_PARAMETERS_FIELD = SdkField
            .<LambdaExecutionParameters> builder(MarshallingType.SDK_POJO).memberName("componentLambdaParameters")
            .getter(getter(LambdaFunctionRecipeSource::componentLambdaParameters))
            .setter(setter(Builder::componentLambdaParameters)).constructor(LambdaExecutionParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentLambdaParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_ARN_FIELD,
            COMPONENT_NAME_FIELD, COMPONENT_VERSION_FIELD, COMPONENT_PLATFORMS_FIELD, COMPONENT_DEPENDENCIES_FIELD,
            COMPONENT_LAMBDA_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lambdaArn;

    private final String componentName;

    private final String componentVersion;

    private final List<ComponentPlatform> componentPlatforms;

    private final Map<String, ComponentDependencyRequirement> componentDependencies;

    private final LambdaExecutionParameters componentLambdaParameters;

    private LambdaFunctionRecipeSource(BuilderImpl builder) {
        this.lambdaArn = builder.lambdaArn;
        this.componentName = builder.componentName;
        this.componentVersion = builder.componentVersion;
        this.componentPlatforms = builder.componentPlatforms;
        this.componentDependencies = builder.componentDependencies;
        this.componentLambdaParameters = builder.componentLambdaParameters;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Lambda
     * function. The ARN must include the version of the function to import. You can't use version aliases like
     * <code>$LATEST</code>.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         Lambda function. The ARN must include the version of the function to import. You can't use version
     *         aliases like <code>$LATEST</code>.
     */
    public final String lambdaArn() {
        return lambdaArn;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * <p>
     * Defaults to the name of the Lambda function.
     * </p>
     * 
     * @return The name of the component.</p>
     *         <p>
     *         Defaults to the name of the Lambda function.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * The version of the component.
     * </p>
     * <p>
     * Defaults to the version of the Lambda function as a semantic version. For example, if your function version is
     * <code>3</code>, the component version becomes <code>3.0.0</code>.
     * </p>
     * 
     * @return The version of the component.</p>
     *         <p>
     *         Defaults to the version of the Lambda function as a semantic version. For example, if your function
     *         version is <code>3</code>, the component version becomes <code>3.0.0</code>.
     */
    public final String componentVersion() {
        return componentVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComponentPlatforms property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComponentPlatforms() {
        return componentPlatforms != null && !(componentPlatforms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The platforms that the component version supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComponentPlatforms} method.
     * </p>
     * 
     * @return The platforms that the component version supports.
     */
    public final List<ComponentPlatform> componentPlatforms() {
        return componentPlatforms;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComponentDependencies property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasComponentDependencies() {
        return componentDependencies != null && !(componentDependencies instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The component versions on which this Lambda function component depends.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComponentDependencies} method.
     * </p>
     * 
     * @return The component versions on which this Lambda function component depends.
     */
    public final Map<String, ComponentDependencyRequirement> componentDependencies() {
        return componentDependencies;
    }

    /**
     * <p>
     * The system and runtime parameters for the Lambda function as it runs on the Greengrass core device.
     * </p>
     * 
     * @return The system and runtime parameters for the Lambda function as it runs on the Greengrass core device.
     */
    public final LambdaExecutionParameters componentLambdaParameters() {
        return componentLambdaParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(componentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasComponentPlatforms() ? componentPlatforms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasComponentDependencies() ? componentDependencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(componentLambdaParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionRecipeSource)) {
            return false;
        }
        LambdaFunctionRecipeSource other = (LambdaFunctionRecipeSource) obj;
        return Objects.equals(lambdaArn(), other.lambdaArn()) && Objects.equals(componentName(), other.componentName())
                && Objects.equals(componentVersion(), other.componentVersion())
                && hasComponentPlatforms() == other.hasComponentPlatforms()
                && Objects.equals(componentPlatforms(), other.componentPlatforms())
                && hasComponentDependencies() == other.hasComponentDependencies()
                && Objects.equals(componentDependencies(), other.componentDependencies())
                && Objects.equals(componentLambdaParameters(), other.componentLambdaParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaFunctionRecipeSource").add("LambdaArn", lambdaArn()).add("ComponentName", componentName())
                .add("ComponentVersion", componentVersion())
                .add("ComponentPlatforms", hasComponentPlatforms() ? componentPlatforms() : null)
                .add("ComponentDependencies", hasComponentDependencies() ? componentDependencies() : null)
                .add("ComponentLambdaParameters", componentLambdaParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lambdaArn":
            return Optional.ofNullable(clazz.cast(lambdaArn()));
        case "componentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "componentVersion":
            return Optional.ofNullable(clazz.cast(componentVersion()));
        case "componentPlatforms":
            return Optional.ofNullable(clazz.cast(componentPlatforms()));
        case "componentDependencies":
            return Optional.ofNullable(clazz.cast(componentDependencies()));
        case "componentLambdaParameters":
            return Optional.ofNullable(clazz.cast(componentLambdaParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lambdaArn", LAMBDA_ARN_FIELD);
        map.put("componentName", COMPONENT_NAME_FIELD);
        map.put("componentVersion", COMPONENT_VERSION_FIELD);
        map.put("componentPlatforms", COMPONENT_PLATFORMS_FIELD);
        map.put("componentDependencies", COMPONENT_DEPENDENCIES_FIELD);
        map.put("componentLambdaParameters", COMPONENT_LAMBDA_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionRecipeSource, T> g) {
        return obj -> g.apply((LambdaFunctionRecipeSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaFunctionRecipeSource> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * Lambda function. The ARN must include the version of the function to import. You can't use version aliases
         * like <code>$LATEST</code>.
         * </p>
         * 
         * @param lambdaArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the Lambda function. The ARN must include the version of the function to import. You can't use version
         *        aliases like <code>$LATEST</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaArn(String lambdaArn);

        /**
         * <p>
         * The name of the component.
         * </p>
         * <p>
         * Defaults to the name of the Lambda function.
         * </p>
         * 
         * @param componentName
         *        The name of the component.</p>
         *        <p>
         *        Defaults to the name of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * The version of the component.
         * </p>
         * <p>
         * Defaults to the version of the Lambda function as a semantic version. For example, if your function version
         * is <code>3</code>, the component version becomes <code>3.0.0</code>.
         * </p>
         * 
         * @param componentVersion
         *        The version of the component.</p>
         *        <p>
         *        Defaults to the version of the Lambda function as a semantic version. For example, if your function
         *        version is <code>3</code>, the component version becomes <code>3.0.0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentVersion(String componentVersion);

        /**
         * <p>
         * The platforms that the component version supports.
         * </p>
         * 
         * @param componentPlatforms
         *        The platforms that the component version supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentPlatforms(Collection<ComponentPlatform> componentPlatforms);

        /**
         * <p>
         * The platforms that the component version supports.
         * </p>
         * 
         * @param componentPlatforms
         *        The platforms that the component version supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentPlatforms(ComponentPlatform... componentPlatforms);

        /**
         * <p>
         * The platforms that the component version supports.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.greengrassv2.model.ComponentPlatform.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.greengrassv2.model.ComponentPlatform#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.greengrassv2.model.ComponentPlatform.Builder#build()} is called
         * immediately and its result is passed to {@link #componentPlatforms(List<ComponentPlatform>)}.
         * 
         * @param componentPlatforms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.greengrassv2.model.ComponentPlatform.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #componentPlatforms(java.util.Collection<ComponentPlatform>)
         */
        Builder componentPlatforms(Consumer<ComponentPlatform.Builder>... componentPlatforms);

        /**
         * <p>
         * The component versions on which this Lambda function component depends.
         * </p>
         * 
         * @param componentDependencies
         *        The component versions on which this Lambda function component depends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentDependencies(Map<String, ComponentDependencyRequirement> componentDependencies);

        /**
         * <p>
         * The system and runtime parameters for the Lambda function as it runs on the Greengrass core device.
         * </p>
         * 
         * @param componentLambdaParameters
         *        The system and runtime parameters for the Lambda function as it runs on the Greengrass core device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentLambdaParameters(LambdaExecutionParameters componentLambdaParameters);

        /**
         * <p>
         * The system and runtime parameters for the Lambda function as it runs on the Greengrass core device.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaExecutionParameters.Builder}
         * avoiding the need to create one manually via {@link LambdaExecutionParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaExecutionParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #componentLambdaParameters(LambdaExecutionParameters)}.
         * 
         * @param componentLambdaParameters
         *        a consumer that will call methods on {@link LambdaExecutionParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #componentLambdaParameters(LambdaExecutionParameters)
         */
        default Builder componentLambdaParameters(Consumer<LambdaExecutionParameters.Builder> componentLambdaParameters) {
            return componentLambdaParameters(LambdaExecutionParameters.builder().applyMutation(componentLambdaParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String lambdaArn;

        private String componentName;

        private String componentVersion;

        private List<ComponentPlatform> componentPlatforms = DefaultSdkAutoConstructList.getInstance();

        private Map<String, ComponentDependencyRequirement> componentDependencies = DefaultSdkAutoConstructMap.getInstance();

        private LambdaExecutionParameters componentLambdaParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionRecipeSource model) {
            lambdaArn(model.lambdaArn);
            componentName(model.componentName);
            componentVersion(model.componentVersion);
            componentPlatforms(model.componentPlatforms);
            componentDependencies(model.componentDependencies);
            componentLambdaParameters(model.componentLambdaParameters);
        }

        public final String getLambdaArn() {
            return lambdaArn;
        }

        public final void setLambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
        }

        @Override
        public final Builder lambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
            return this;
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentVersion() {
            return componentVersion;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        @Override
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public final List<ComponentPlatform.Builder> getComponentPlatforms() {
            List<ComponentPlatform.Builder> result = ComponentPlatformListCopier.copyToBuilder(this.componentPlatforms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponentPlatforms(Collection<ComponentPlatform.BuilderImpl> componentPlatforms) {
            this.componentPlatforms = ComponentPlatformListCopier.copyFromBuilder(componentPlatforms);
        }

        @Override
        public final Builder componentPlatforms(Collection<ComponentPlatform> componentPlatforms) {
            this.componentPlatforms = ComponentPlatformListCopier.copy(componentPlatforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentPlatforms(ComponentPlatform... componentPlatforms) {
            componentPlatforms(Arrays.asList(componentPlatforms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentPlatforms(Consumer<ComponentPlatform.Builder>... componentPlatforms) {
            componentPlatforms(Stream.of(componentPlatforms).map(c -> ComponentPlatform.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, ComponentDependencyRequirement.Builder> getComponentDependencies() {
            Map<String, ComponentDependencyRequirement.Builder> result = ComponentDependencyMapCopier
                    .copyToBuilder(this.componentDependencies);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setComponentDependencies(Map<String, ComponentDependencyRequirement.BuilderImpl> componentDependencies) {
            this.componentDependencies = ComponentDependencyMapCopier.copyFromBuilder(componentDependencies);
        }

        @Override
        public final Builder componentDependencies(Map<String, ComponentDependencyRequirement> componentDependencies) {
            this.componentDependencies = ComponentDependencyMapCopier.copy(componentDependencies);
            return this;
        }

        public final LambdaExecutionParameters.Builder getComponentLambdaParameters() {
            return componentLambdaParameters != null ? componentLambdaParameters.toBuilder() : null;
        }

        public final void setComponentLambdaParameters(LambdaExecutionParameters.BuilderImpl componentLambdaParameters) {
            this.componentLambdaParameters = componentLambdaParameters != null ? componentLambdaParameters.build() : null;
        }

        @Override
        public final Builder componentLambdaParameters(LambdaExecutionParameters componentLambdaParameters) {
            this.componentLambdaParameters = componentLambdaParameters;
            return this;
        }

        @Override
        public LambdaFunctionRecipeSource build() {
            return new LambdaFunctionRecipeSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
