/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateComponentVersionResponse extends GreengrassV2Response implements
        ToCopyableBuilder<CreateComponentVersionResponse.Builder, CreateComponentVersionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateComponentVersionResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentName").getter(getter(CreateComponentVersionResponse::componentName))
            .setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()).build();

    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentVersion").getter(getter(CreateComponentVersionResponse::componentVersion))
            .setter(setter(Builder::componentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersion").build()).build();

    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTimestamp").getter(getter(CreateComponentVersionResponse::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()).build();

    private static final SdkField<CloudComponentStatus> STATUS_FIELD = SdkField
            .<CloudComponentStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(CreateComponentVersionResponse::status)).setter(setter(Builder::status))
            .constructor(CloudComponentStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            COMPONENT_NAME_FIELD, COMPONENT_VERSION_FIELD, CREATION_TIMESTAMP_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String componentName;

    private final String componentVersion;

    private final Instant creationTimestamp;

    private final CloudComponentStatus status;

    private CreateComponentVersionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.componentName = builder.componentName;
        this.componentVersion = builder.componentVersion;
        this.creationTimestamp = builder.creationTimestamp;
        this.status = builder.status;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component
     * version.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         component version.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * The version of the component.
     * </p>
     * 
     * @return The version of the component.
     */
    public final String componentVersion() {
        return componentVersion;
    }

    /**
     * <p>
     * The time at which the component was created, expressed in ISO 8601 format.
     * </p>
     * 
     * @return The time at which the component was created, expressed in ISO 8601 format.
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The status of the component version in IoT Greengrass V2. This status is different from the status of the
     * component on a core device.
     * </p>
     * 
     * @return The status of the component version in IoT Greengrass V2. This status is different from the status of the
     *         component on a core device.
     */
    public final CloudComponentStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(componentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComponentVersionResponse)) {
            return false;
        }
        CreateComponentVersionResponse other = (CreateComponentVersionResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(componentName(), other.componentName())
                && Objects.equals(componentVersion(), other.componentVersion())
                && Objects.equals(creationTimestamp(), other.creationTimestamp()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateComponentVersionResponse").add("Arn", arn()).add("ComponentName", componentName())
                .add("ComponentVersion", componentVersion()).add("CreationTimestamp", creationTimestamp())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "componentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "componentVersion":
            return Optional.ofNullable(clazz.cast(componentVersion()));
        case "creationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("componentName", COMPONENT_NAME_FIELD);
        map.put("componentVersion", COMPONENT_VERSION_FIELD);
        map.put("creationTimestamp", CREATION_TIMESTAMP_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateComponentVersionResponse, T> g) {
        return obj -> g.apply((CreateComponentVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GreengrassV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateComponentVersionResponse> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * component version.
         * </p>
         * 
         * @param arn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the component version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param componentName
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * The version of the component.
         * </p>
         * 
         * @param componentVersion
         *        The version of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentVersion(String componentVersion);

        /**
         * <p>
         * The time at which the component was created, expressed in ISO 8601 format.
         * </p>
         * 
         * @param creationTimestamp
         *        The time at which the component was created, expressed in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The status of the component version in IoT Greengrass V2. This status is different from the status of the
         * component on a core device.
         * </p>
         * 
         * @param status
         *        The status of the component version in IoT Greengrass V2. This status is different from the status of
         *        the component on a core device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(CloudComponentStatus status);

        /**
         * <p>
         * The status of the component version in IoT Greengrass V2. This status is different from the status of the
         * component on a core device.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudComponentStatus.Builder} avoiding
         * the need to create one manually via {@link CloudComponentStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudComponentStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(CloudComponentStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link CloudComponentStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(CloudComponentStatus)
         */
        default Builder status(Consumer<CloudComponentStatus.Builder> status) {
            return status(CloudComponentStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl extends GreengrassV2Response.BuilderImpl implements Builder {
        private String arn;

        private String componentName;

        private String componentVersion;

        private Instant creationTimestamp;

        private CloudComponentStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComponentVersionResponse model) {
            super(model);
            arn(model.arn);
            componentName(model.componentName);
            componentVersion(model.componentVersion);
            creationTimestamp(model.creationTimestamp);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentVersion() {
            return componentVersion;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        @Override
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final CloudComponentStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(CloudComponentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(CloudComponentStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public CreateComponentVersionResponse build() {
            return new CreateComponentVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
