/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.CoreDeviceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoreDevice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoreDevice> {
    private static final SdkField<String> CORE_DEVICE_THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("coreDeviceThingName").getter(CoreDevice.getter(CoreDevice::coreDeviceThingName)).setter(CoreDevice.setter(Builder::coreDeviceThingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coreDeviceThingName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CoreDevice.getter(CoreDevice::statusAsString)).setter(CoreDevice.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_STATUS_UPDATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStatusUpdateTimestamp").getter(CoreDevice.getter(CoreDevice::lastStatusUpdateTimestamp)).setter(CoreDevice.setter(Builder::lastStatusUpdateTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusUpdateTimestamp").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(CoreDevice.getter(CoreDevice::platform)).setter(CoreDevice.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("architecture").getter(CoreDevice.getter(CoreDevice::architecture)).setter(CoreDevice.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()}).build();
    private static final SdkField<String> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtime").getter(CoreDevice.getter(CoreDevice::runtime)).setter(CoreDevice.setter(Builder::runtime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_DEVICE_THING_NAME_FIELD, STATUS_FIELD, LAST_STATUS_UPDATE_TIMESTAMP_FIELD, PLATFORM_FIELD, ARCHITECTURE_FIELD, RUNTIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CoreDevice.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String coreDeviceThingName;
    private final String status;
    private final Instant lastStatusUpdateTimestamp;
    private final String platform;
    private final String architecture;
    private final String runtime;

    private CoreDevice(BuilderImpl builder) {
        this.coreDeviceThingName = builder.coreDeviceThingName;
        this.status = builder.status;
        this.lastStatusUpdateTimestamp = builder.lastStatusUpdateTimestamp;
        this.platform = builder.platform;
        this.architecture = builder.architecture;
        this.runtime = builder.runtime;
    }

    public final String coreDeviceThingName() {
        return this.coreDeviceThingName;
    }

    public final CoreDeviceStatus status() {
        return CoreDeviceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastStatusUpdateTimestamp() {
        return this.lastStatusUpdateTimestamp;
    }

    public final String platform() {
        return this.platform;
    }

    public final String architecture() {
        return this.architecture;
    }

    public final String runtime() {
        return this.runtime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coreDeviceThingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.architecture());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreDevice)) {
            return false;
        }
        CoreDevice other = (CoreDevice)obj;
        return Objects.equals(this.coreDeviceThingName(), other.coreDeviceThingName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastStatusUpdateTimestamp(), other.lastStatusUpdateTimestamp()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.architecture(), other.architecture()) && Objects.equals(this.runtime(), other.runtime());
    }

    public final String toString() {
        return ToString.builder((String)"CoreDevice").add("CoreDeviceThingName", (Object)this.coreDeviceThingName()).add("Status", (Object)this.statusAsString()).add("LastStatusUpdateTimestamp", (Object)this.lastStatusUpdateTimestamp()).add("Platform", (Object)this.platform()).add("Architecture", (Object)this.architecture()).add("Runtime", (Object)this.runtime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "coreDeviceThingName": {
                return Optional.ofNullable(clazz.cast(this.coreDeviceThingName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastStatusUpdateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastStatusUpdateTimestamp()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "architecture": {
                return Optional.ofNullable(clazz.cast(this.architecture()));
            }
            case "runtime": {
                return Optional.ofNullable(clazz.cast(this.runtime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("coreDeviceThingName", CORE_DEVICE_THING_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("lastStatusUpdateTimestamp", LAST_STATUS_UPDATE_TIMESTAMP_FIELD);
        map.put("platform", PLATFORM_FIELD);
        map.put("architecture", ARCHITECTURE_FIELD);
        map.put("runtime", RUNTIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoreDevice, T> g) {
        return obj -> g.apply((CoreDevice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String coreDeviceThingName;
        private String status;
        private Instant lastStatusUpdateTimestamp;
        private String platform;
        private String architecture;
        private String runtime;

        private BuilderImpl() {
        }

        private BuilderImpl(CoreDevice model) {
            this.coreDeviceThingName(model.coreDeviceThingName);
            this.status(model.status);
            this.lastStatusUpdateTimestamp(model.lastStatusUpdateTimestamp);
            this.platform(model.platform);
            this.architecture(model.architecture);
            this.runtime(model.runtime);
        }

        public final String getCoreDeviceThingName() {
            return this.coreDeviceThingName;
        }

        public final void setCoreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
        }

        @Override
        public final Builder coreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CoreDeviceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastStatusUpdateTimestamp() {
            return this.lastStatusUpdateTimestamp;
        }

        public final void setLastStatusUpdateTimestamp(Instant lastStatusUpdateTimestamp) {
            this.lastStatusUpdateTimestamp = lastStatusUpdateTimestamp;
        }

        @Override
        public final Builder lastStatusUpdateTimestamp(Instant lastStatusUpdateTimestamp) {
            this.lastStatusUpdateTimestamp = lastStatusUpdateTimestamp;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final String getRuntime() {
            return this.runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        public CoreDevice build() {
            return new CoreDevice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoreDevice> {
        public Builder coreDeviceThingName(String var1);

        public Builder status(String var1);

        public Builder status(CoreDeviceStatus var1);

        public Builder lastStatusUpdateTimestamp(Instant var1);

        public Builder platform(String var1);

        public Builder architecture(String var1);

        public Builder runtime(String var1);
    }
}

