/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrassv2.model.ComponentPlatform;
import software.amazon.awssdk.services.greengrassv2.model.ComponentPlatformListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentLatestVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentLatestVersion> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ComponentLatestVersion.getter(ComponentLatestVersion::arn)).setter(ComponentLatestVersion.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentVersion").getter(ComponentLatestVersion.getter(ComponentLatestVersion::componentVersion)).setter(ComponentLatestVersion.setter(Builder::componentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersion").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTimestamp").getter(ComponentLatestVersion.getter(ComponentLatestVersion::creationTimestamp)).setter(ComponentLatestVersion.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ComponentLatestVersion.getter(ComponentLatestVersion::description)).setter(ComponentLatestVersion.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> PUBLISHER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("publisher").getter(ComponentLatestVersion.getter(ComponentLatestVersion::publisher)).setter(ComponentLatestVersion.setter(Builder::publisher)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publisher").build()}).build();
    private static final SdkField<List<ComponentPlatform>> PLATFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("platforms").getter(ComponentLatestVersion.getter(ComponentLatestVersion::platforms)).setter(ComponentLatestVersion.setter(Builder::platforms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platforms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentPlatform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COMPONENT_VERSION_FIELD, CREATION_TIMESTAMP_FIELD, DESCRIPTION_FIELD, PUBLISHER_FIELD, PLATFORMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("componentVersion", COMPONENT_VERSION_FIELD);
            this.put("creationTimestamp", CREATION_TIMESTAMP_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("publisher", PUBLISHER_FIELD);
            this.put("platforms", PLATFORMS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String componentVersion;
    private final Instant creationTimestamp;
    private final String description;
    private final String publisher;
    private final List<ComponentPlatform> platforms;

    private ComponentLatestVersion(BuilderImpl builder) {
        this.arn = builder.arn;
        this.componentVersion = builder.componentVersion;
        this.creationTimestamp = builder.creationTimestamp;
        this.description = builder.description;
        this.publisher = builder.publisher;
        this.platforms = builder.platforms;
    }

    public final String arn() {
        return this.arn;
    }

    public final String componentVersion() {
        return this.componentVersion;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final String description() {
        return this.description;
    }

    public final String publisher() {
        return this.publisher;
    }

    public final boolean hasPlatforms() {
        return this.platforms != null && !(this.platforms instanceof SdkAutoConstructList);
    }

    public final List<ComponentPlatform> platforms() {
        return this.platforms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.publisher());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatforms() ? this.platforms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentLatestVersion)) {
            return false;
        }
        ComponentLatestVersion other = (ComponentLatestVersion)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.componentVersion(), other.componentVersion()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.publisher(), other.publisher()) && this.hasPlatforms() == other.hasPlatforms() && Objects.equals(this.platforms(), other.platforms());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentLatestVersion").add("Arn", (Object)this.arn()).add("ComponentVersion", (Object)this.componentVersion()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("Description", (Object)this.description()).add("Publisher", (Object)this.publisher()).add("Platforms", this.hasPlatforms() ? this.platforms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "componentVersion": {
                return Optional.ofNullable(clazz.cast(this.componentVersion()));
            }
            case "creationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "publisher": {
                return Optional.ofNullable(clazz.cast(this.publisher()));
            }
            case "platforms": {
                return Optional.ofNullable(clazz.cast(this.platforms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ComponentLatestVersion, T> g) {
        return obj -> g.apply((ComponentLatestVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String componentVersion;
        private Instant creationTimestamp;
        private String description;
        private String publisher;
        private List<ComponentPlatform> platforms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentLatestVersion model) {
            this.arn(model.arn);
            this.componentVersion(model.componentVersion);
            this.creationTimestamp(model.creationTimestamp);
            this.description(model.description);
            this.publisher(model.publisher);
            this.platforms(model.platforms);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getComponentVersion() {
            return this.componentVersion;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        @Override
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPublisher() {
            return this.publisher;
        }

        public final void setPublisher(String publisher) {
            this.publisher = publisher;
        }

        @Override
        public final Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public final List<ComponentPlatform.Builder> getPlatforms() {
            List<ComponentPlatform.Builder> result = ComponentPlatformListCopier.copyToBuilder(this.platforms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlatforms(Collection<ComponentPlatform.BuilderImpl> platforms) {
            this.platforms = ComponentPlatformListCopier.copyFromBuilder(platforms);
        }

        @Override
        public final Builder platforms(Collection<ComponentPlatform> platforms) {
            this.platforms = ComponentPlatformListCopier.copy(platforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(ComponentPlatform ... platforms) {
            this.platforms(Arrays.asList(platforms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(Consumer<ComponentPlatform.Builder> ... platforms) {
            this.platforms(Stream.of(platforms).map(c -> (ComponentPlatform)((ComponentPlatform.Builder)ComponentPlatform.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ComponentLatestVersion build() {
            return new ComponentLatestVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentLatestVersion> {
        public Builder arn(String var1);

        public Builder componentVersion(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder description(String var1);

        public Builder publisher(String var1);

        public Builder platforms(Collection<ComponentPlatform> var1);

        public Builder platforms(ComponentPlatform ... var1);

        public Builder platforms(Consumer<ComponentPlatform.Builder> ... var1);
    }
}

