/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IotEndpointType {
    FIPS("fips"),
    STANDARD("standard"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IotEndpointType> VALUE_MAP;
    private final String value;

    private IotEndpointType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IotEndpointType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IotEndpointType> knownValues() {
        EnumSet<IotEndpointType> knownValues = EnumSet.allOf(IotEndpointType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IotEndpointType.class, IotEndpointType::toString);
    }
}

