/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.greengrassv2.GreengrassV2Client;
import software.amazon.awssdk.services.greengrassv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.greengrassv2.model.AssociatedClientDevice;
import software.amazon.awssdk.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceRequest;
import software.amazon.awssdk.services.greengrassv2.model.ListClientDevicesAssociatedWithCoreDeviceResponse;

public class ListClientDevicesAssociatedWithCoreDeviceIterable
implements SdkIterable<ListClientDevicesAssociatedWithCoreDeviceResponse> {
    private final GreengrassV2Client client;
    private final ListClientDevicesAssociatedWithCoreDeviceRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClientDevicesAssociatedWithCoreDeviceIterable(GreengrassV2Client client, ListClientDevicesAssociatedWithCoreDeviceRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListClientDevicesAssociatedWithCoreDeviceResponseFetcher();
    }

    public Iterator<ListClientDevicesAssociatedWithCoreDeviceResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssociatedClientDevice> associatedClientDevices() {
        Function<ListClientDevicesAssociatedWithCoreDeviceResponse, Iterator> getIterator = response -> {
            if (response != null && response.associatedClientDevices() != null) {
                return response.associatedClientDevices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListClientDevicesAssociatedWithCoreDeviceResponseFetcher
    implements SyncPageFetcher<ListClientDevicesAssociatedWithCoreDeviceResponse> {
        private ListClientDevicesAssociatedWithCoreDeviceResponseFetcher() {
        }

        public boolean hasNextPage(ListClientDevicesAssociatedWithCoreDeviceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListClientDevicesAssociatedWithCoreDeviceResponse nextPage(ListClientDevicesAssociatedWithCoreDeviceResponse previousPage) {
            if (previousPage == null) {
                return ListClientDevicesAssociatedWithCoreDeviceIterable.this.client.listClientDevicesAssociatedWithCoreDevice(ListClientDevicesAssociatedWithCoreDeviceIterable.this.firstRequest);
            }
            return ListClientDevicesAssociatedWithCoreDeviceIterable.this.client.listClientDevicesAssociatedWithCoreDevice((ListClientDevicesAssociatedWithCoreDeviceRequest)((Object)ListClientDevicesAssociatedWithCoreDeviceIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

