/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CloudComponentState {
    REQUESTED("REQUESTED"),
    INITIATED("INITIATED"),
    DEPLOYABLE("DEPLOYABLE"),
    FAILED("FAILED"),
    DEPRECATED("DEPRECATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CloudComponentState> VALUE_MAP;
    private final String value;

    private CloudComponentState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CloudComponentState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CloudComponentState> knownValues() {
        EnumSet<CloudComponentState> knownValues = EnumSet.allOf(CloudComponentState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CloudComponentState.class, CloudComponentState::toString);
    }
}

