/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.GreengrassV2Request;
import software.amazon.awssdk.services.greengrassv2.model.RecipeOutputFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetComponentRequest
extends GreengrassV2Request
implements ToCopyableBuilder<Builder, GetComponentRequest> {
    private static final SdkField<String> RECIPE_OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recipeOutputFormat").getter(GetComponentRequest.getter(GetComponentRequest::recipeOutputFormatAsString)).setter(GetComponentRequest.setter(Builder::recipeOutputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("recipeOutputFormat").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetComponentRequest.getter(GetComponentRequest::arn)).setter(GetComponentRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECIPE_OUTPUT_FORMAT_FIELD, ARN_FIELD));
    private final String recipeOutputFormat;
    private final String arn;

    private GetComponentRequest(BuilderImpl builder) {
        super(builder);
        this.recipeOutputFormat = builder.recipeOutputFormat;
        this.arn = builder.arn;
    }

    public final RecipeOutputFormat recipeOutputFormat() {
        return RecipeOutputFormat.fromValue(this.recipeOutputFormat);
    }

    public final String recipeOutputFormatAsString() {
        return this.recipeOutputFormat;
    }

    public final String arn() {
        return this.arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeOutputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComponentRequest)) {
            return false;
        }
        GetComponentRequest other = (GetComponentRequest)((Object)obj);
        return Objects.equals(this.recipeOutputFormatAsString(), other.recipeOutputFormatAsString()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"GetComponentRequest").add("RecipeOutputFormat", (Object)this.recipeOutputFormatAsString()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recipeOutputFormat": {
                return Optional.ofNullable(clazz.cast(this.recipeOutputFormatAsString()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComponentRequest, T> g) {
        return obj -> g.apply((GetComponentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassV2Request.BuilderImpl
    implements Builder {
        private String recipeOutputFormat;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComponentRequest model) {
            super(model);
            this.recipeOutputFormat(model.recipeOutputFormat);
            this.arn(model.arn);
        }

        public final String getRecipeOutputFormat() {
            return this.recipeOutputFormat;
        }

        public final void setRecipeOutputFormat(String recipeOutputFormat) {
            this.recipeOutputFormat = recipeOutputFormat;
        }

        @Override
        @Transient
        public final Builder recipeOutputFormat(String recipeOutputFormat) {
            this.recipeOutputFormat = recipeOutputFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder recipeOutputFormat(RecipeOutputFormat recipeOutputFormat) {
            this.recipeOutputFormat(recipeOutputFormat == null ? null : recipeOutputFormat.toString());
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetComponentRequest build() {
            return new GetComponentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetComponentRequest> {
        public Builder recipeOutputFormat(String var1);

        public Builder recipeOutputFormat(RecipeOutputFormat var1);

        public Builder arn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

