/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.ComponentLatestVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Component
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Component> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Component.getter(Component::arn)).setter(Component.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(Component.getter(Component::componentName)).setter(Component.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<ComponentLatestVersion> LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestVersion").getter(Component.getter(Component::latestVersion)).setter(Component.setter(Builder::latestVersion)).constructor(ComponentLatestVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COMPONENT_NAME_FIELD, LATEST_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String componentName;
    private final ComponentLatestVersion latestVersion;

    private Component(BuilderImpl builder) {
        this.arn = builder.arn;
        this.componentName = builder.componentName;
        this.latestVersion = builder.latestVersion;
    }

    public String arn() {
        return this.arn;
    }

    public String componentName() {
        return this.componentName;
    }

    public ComponentLatestVersion latestVersion() {
        return this.latestVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Component)) {
            return false;
        }
        Component other = (Component)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.latestVersion(), other.latestVersion());
    }

    public String toString() {
        return ToString.builder((String)"Component").add("Arn", (Object)this.arn()).add("ComponentName", (Object)this.componentName()).add("LatestVersion", (Object)this.latestVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "latestVersion": {
                return Optional.ofNullable(clazz.cast(this.latestVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Component, T> g) {
        return obj -> g.apply((Component)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String componentName;
        private ComponentLatestVersion latestVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Component model) {
            this.arn(model.arn);
            this.componentName(model.componentName);
            this.latestVersion(model.latestVersion);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getComponentName() {
            return this.componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        public final ComponentLatestVersion.Builder getLatestVersion() {
            return this.latestVersion != null ? this.latestVersion.toBuilder() : null;
        }

        @Override
        public final Builder latestVersion(ComponentLatestVersion latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final void setLatestVersion(ComponentLatestVersion.BuilderImpl latestVersion) {
            this.latestVersion = latestVersion != null ? latestVersion.build() : null;
        }

        public Component build() {
            return new Component(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Component> {
        public Builder arn(String var1);

        public Builder componentName(String var1);

        public Builder latestVersion(ComponentLatestVersion var1);

        default public Builder latestVersion(Consumer<ComponentLatestVersion.Builder> latestVersion) {
            return this.latestVersion((ComponentLatestVersion)((ComponentLatestVersion.Builder)ComponentLatestVersion.builder().applyMutation(latestVersion)).build());
        }
    }
}

