/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.greengrassv2.model.CloudComponentState;
import software.amazon.awssdk.services.greengrassv2.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudComponentStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudComponentStatus> {
    private static final SdkField<String> COMPONENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentState").getter(CloudComponentStatus.getter(CloudComponentStatus::componentStateAsString)).setter(CloudComponentStatus.setter(Builder::componentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentState").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(CloudComponentStatus.getter(CloudComponentStatus::message)).setter(CloudComponentStatus.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Map<String, String>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("errors").getter(CloudComponentStatus.getter(CloudComponentStatus::errors)).setter(CloudComponentStatus.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_STATE_FIELD, MESSAGE_FIELD, ERRORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String componentState;
    private final String message;
    private final Map<String, String> errors;

    private CloudComponentStatus(BuilderImpl builder) {
        this.componentState = builder.componentState;
        this.message = builder.message;
        this.errors = builder.errors;
    }

    public CloudComponentState componentState() {
        return CloudComponentState.fromValue(this.componentState);
    }

    public String componentStateAsString() {
        return this.componentState;
    }

    public String message() {
        return this.message;
    }

    public boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructMap);
    }

    public Map<String, String> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudComponentStatus)) {
            return false;
        }
        CloudComponentStatus other = (CloudComponentStatus)obj;
        return Objects.equals(this.componentStateAsString(), other.componentStateAsString()) && Objects.equals(this.message(), other.message()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public String toString() {
        return ToString.builder((String)"CloudComponentStatus").add("ComponentState", (Object)this.componentStateAsString()).add("Message", (Object)this.message()).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentState": {
                return Optional.ofNullable(clazz.cast(this.componentStateAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudComponentStatus, T> g) {
        return obj -> g.apply((CloudComponentStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentState;
        private String message;
        private Map<String, String> errors = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudComponentStatus model) {
            this.componentState(model.componentState);
            this.message(model.message);
            this.errors(model.errors);
        }

        public final String getComponentState() {
            return this.componentState;
        }

        @Override
        public final Builder componentState(String componentState) {
            this.componentState = componentState;
            return this;
        }

        @Override
        public final Builder componentState(CloudComponentState componentState) {
            this.componentState(componentState == null ? null : componentState.toString());
            return this;
        }

        public final void setComponentState(String componentState) {
            this.componentState = componentState;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Map<String, String> getErrors() {
            if (this.errors instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.errors;
        }

        @Override
        public final Builder errors(Map<String, String> errors) {
            this.errors = StringMapCopier.copy(errors);
            return this;
        }

        public final void setErrors(Map<String, String> errors) {
            this.errors = StringMapCopier.copy(errors);
        }

        public CloudComponentStatus build() {
            return new CloudComponentStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudComponentStatus> {
        public Builder componentState(String var1);

        public Builder componentState(CloudComponentState var1);

        public Builder message(String var1);

        public Builder errors(Map<String, String> var1);
    }
}

