/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.greengrassv2.model.GreengrassV2Response;
import software.amazon.awssdk.services.greengrassv2.model.RecipeOutputFormat;
import software.amazon.awssdk.services.greengrassv2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetComponentResponse
extends GreengrassV2Response
implements ToCopyableBuilder<Builder, GetComponentResponse> {
    private static final SdkField<String> RECIPE_OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recipeOutputFormat").getter(GetComponentResponse.getter(GetComponentResponse::recipeOutputFormatAsString)).setter(GetComponentResponse.setter(Builder::recipeOutputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipeOutputFormat").build()}).build();
    private static final SdkField<SdkBytes> RECIPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("recipe").getter(GetComponentResponse.getter(GetComponentResponse::recipe)).setter(GetComponentResponse.setter(Builder::recipe)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipe").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetComponentResponse.getter(GetComponentResponse::tags)).setter(GetComponentResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECIPE_OUTPUT_FORMAT_FIELD, RECIPE_FIELD, TAGS_FIELD));
    private final String recipeOutputFormat;
    private final SdkBytes recipe;
    private final Map<String, String> tags;

    private GetComponentResponse(BuilderImpl builder) {
        super(builder);
        this.recipeOutputFormat = builder.recipeOutputFormat;
        this.recipe = builder.recipe;
        this.tags = builder.tags;
    }

    public RecipeOutputFormat recipeOutputFormat() {
        return RecipeOutputFormat.fromValue(this.recipeOutputFormat);
    }

    public String recipeOutputFormatAsString() {
        return this.recipeOutputFormat;
    }

    public SdkBytes recipe() {
        return this.recipe;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeOutputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipe());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComponentResponse)) {
            return false;
        }
        GetComponentResponse other = (GetComponentResponse)((Object)obj);
        return Objects.equals(this.recipeOutputFormatAsString(), other.recipeOutputFormatAsString()) && Objects.equals(this.recipe(), other.recipe()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"GetComponentResponse").add("RecipeOutputFormat", (Object)this.recipeOutputFormatAsString()).add("Recipe", (Object)this.recipe()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recipeOutputFormat": {
                return Optional.ofNullable(clazz.cast(this.recipeOutputFormatAsString()));
            }
            case "recipe": {
                return Optional.ofNullable(clazz.cast(this.recipe()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComponentResponse, T> g) {
        return obj -> g.apply((GetComponentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassV2Response.BuilderImpl
    implements Builder {
        private String recipeOutputFormat;
        private SdkBytes recipe;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetComponentResponse model) {
            super(model);
            this.recipeOutputFormat(model.recipeOutputFormat);
            this.recipe(model.recipe);
            this.tags(model.tags);
        }

        public final String getRecipeOutputFormat() {
            return this.recipeOutputFormat;
        }

        @Override
        public final Builder recipeOutputFormat(String recipeOutputFormat) {
            this.recipeOutputFormat = recipeOutputFormat;
            return this;
        }

        @Override
        public final Builder recipeOutputFormat(RecipeOutputFormat recipeOutputFormat) {
            this.recipeOutputFormat(recipeOutputFormat == null ? null : recipeOutputFormat.toString());
            return this;
        }

        public final void setRecipeOutputFormat(String recipeOutputFormat) {
            this.recipeOutputFormat = recipeOutputFormat;
        }

        public final ByteBuffer getRecipe() {
            return this.recipe == null ? null : this.recipe.asByteBuffer();
        }

        @Override
        public final Builder recipe(SdkBytes recipe) {
            this.recipe = StandardMemberCopier.copy((SdkBytes)recipe);
            return this;
        }

        public final void setRecipe(ByteBuffer recipe) {
            this.recipe(recipe == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)recipe));
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public GetComponentResponse build() {
            return new GetComponentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetComponentResponse> {
        public Builder recipeOutputFormat(String var1);

        public Builder recipeOutputFormat(RecipeOutputFormat var1);

        public Builder recipe(SdkBytes var1);

        public Builder tags(Map<String, String> var1);
    }
}

