/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrass.model.LoggerComponent;
import software.amazon.awssdk.services.greengrass.model.LoggerLevel;
import software.amazon.awssdk.services.greengrass.model.LoggerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Logger
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Logger> {
    private static final SdkField<String> COMPONENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Logger.getter(Logger::componentAsString)).setter(Logger.setter(Builder::component)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Component").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Logger.getter(Logger::id)).setter(Logger.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Logger.getter(Logger::levelAsString)).setter(Logger.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Level").build()}).build();
    private static final SdkField<Integer> SPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Logger.getter(Logger::space)).setter(Logger.setter(Builder::space)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Space").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Logger.getter(Logger::typeAsString)).setter(Logger.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_FIELD, ID_FIELD, LEVEL_FIELD, SPACE_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String component;
    private final String id;
    private final String level;
    private final Integer space;
    private final String type;

    private Logger(BuilderImpl builder) {
        this.component = builder.component;
        this.id = builder.id;
        this.level = builder.level;
        this.space = builder.space;
        this.type = builder.type;
    }

    public LoggerComponent component() {
        return LoggerComponent.fromValue(this.component);
    }

    public String componentAsString() {
        return this.component;
    }

    public String id() {
        return this.id;
    }

    public LoggerLevel level() {
        return LoggerLevel.fromValue(this.level);
    }

    public String levelAsString() {
        return this.level;
    }

    public Integer space() {
        return this.space;
    }

    public LoggerType type() {
        return LoggerType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.space());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Logger)) {
            return false;
        }
        Logger other = (Logger)obj;
        return Objects.equals(this.componentAsString(), other.componentAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.levelAsString(), other.levelAsString()) && Objects.equals(this.space(), other.space()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"Logger").add("Component", (Object)this.componentAsString()).add("Id", (Object)this.id()).add("Level", (Object)this.levelAsString()).add("Space", (Object)this.space()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Component": {
                return Optional.ofNullable(clazz.cast(this.componentAsString()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Level": {
                return Optional.ofNullable(clazz.cast(this.levelAsString()));
            }
            case "Space": {
                return Optional.ofNullable(clazz.cast(this.space()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Logger, T> g) {
        return obj -> g.apply((Logger)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String component;
        private String id;
        private String level;
        private Integer space;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Logger model) {
            this.component(model.component);
            this.id(model.id);
            this.level(model.level);
            this.space(model.space);
            this.type(model.type);
        }

        public final String getComponentAsString() {
            return this.component;
        }

        @Override
        public final Builder component(String component) {
            this.component = component;
            return this;
        }

        @Override
        public final Builder component(LoggerComponent component) {
            this.component(component.toString());
            return this;
        }

        public final void setComponent(String component) {
            this.component = component;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getLevelAsString() {
            return this.level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(LoggerLevel level) {
            this.level(level.toString());
            return this;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        public final Integer getSpace() {
            return this.space;
        }

        @Override
        public final Builder space(Integer space) {
            this.space = space;
            return this;
        }

        public final void setSpace(Integer space) {
            this.space = space;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LoggerType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public Logger build() {
            return new Logger(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Logger> {
        public Builder component(String var1);

        public Builder component(LoggerComponent var1);

        public Builder id(String var1);

        public Builder level(String var1);

        public Builder level(LoggerLevel var1);

        public Builder space(Integer var1);

        public Builder type(String var1);

        public Builder type(LoggerType var1);
    }
}

