/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.greengrass.model.DeviceDefinitionVersion;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.services.greengrass.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeviceDefinitionRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, CreateDeviceDefinitionRequest> {
    private static final SdkField<String> AMZN_CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDeviceDefinitionRequest.getter(CreateDeviceDefinitionRequest::amznClientToken)).setter(CreateDeviceDefinitionRequest.setter(Builder::amznClientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build()}).build();
    private static final SdkField<DeviceDefinitionVersion> INITIAL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateDeviceDefinitionRequest.getter(CreateDeviceDefinitionRequest::initialVersion)).setter(CreateDeviceDefinitionRequest.setter(Builder::initialVersion)).constructor(DeviceDefinitionVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialVersion").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDeviceDefinitionRequest.getter(CreateDeviceDefinitionRequest::name)).setter(CreateDeviceDefinitionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateDeviceDefinitionRequest.getter(CreateDeviceDefinitionRequest::tags)).setter(CreateDeviceDefinitionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMZN_CLIENT_TOKEN_FIELD, INITIAL_VERSION_FIELD, NAME_FIELD, TAGS_FIELD));
    private final String amznClientToken;
    private final DeviceDefinitionVersion initialVersion;
    private final String name;
    private final Map<String, String> tags;

    private CreateDeviceDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.initialVersion = builder.initialVersion;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public DeviceDefinitionVersion initialVersion() {
        return this.initialVersion;
    }

    public String name() {
        return this.name;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeviceDefinitionRequest)) {
            return false;
        }
        CreateDeviceDefinitionRequest other = (CreateDeviceDefinitionRequest)((Object)obj);
        return Objects.equals(this.amznClientToken(), other.amznClientToken()) && Objects.equals(this.initialVersion(), other.initialVersion()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateDeviceDefinitionRequest").add("AmznClientToken", (Object)this.amznClientToken()).add("InitialVersion", (Object)this.initialVersion()).add("Name", (Object)this.name()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.ofNullable(clazz.cast(this.amznClientToken()));
            }
            case "InitialVersion": {
                return Optional.ofNullable(clazz.cast(this.initialVersion()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeviceDefinitionRequest, T> g) {
        return obj -> g.apply((CreateDeviceDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String amznClientToken;
        private DeviceDefinitionVersion initialVersion;
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeviceDefinitionRequest model) {
            super(model);
            this.amznClientToken(model.amznClientToken);
            this.initialVersion(model.initialVersion);
            this.name(model.name);
            this.tags(model.tags);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final DeviceDefinitionVersion.Builder getInitialVersion() {
            return this.initialVersion != null ? this.initialVersion.toBuilder() : null;
        }

        @Override
        public final Builder initialVersion(DeviceDefinitionVersion initialVersion) {
            this.initialVersion = initialVersion;
            return this;
        }

        public final void setInitialVersion(DeviceDefinitionVersion.BuilderImpl initialVersion) {
            this.initialVersion = initialVersion != null ? initialVersion.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeviceDefinitionRequest build() {
            return new CreateDeviceDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeviceDefinitionRequest> {
        public Builder amznClientToken(String var1);

        public Builder initialVersion(DeviceDefinitionVersion var1);

        default public Builder initialVersion(Consumer<DeviceDefinitionVersion.Builder> initialVersion) {
            return this.initialVersion((DeviceDefinitionVersion)((DeviceDefinitionVersion.Builder)DeviceDefinitionVersion.builder().applyMutation(initialVersion)).build());
        }

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

