/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BulkDeploymentMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BulkDeploymentMetrics> {
    private static final SdkField<Integer> INVALID_INPUT_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BulkDeploymentMetrics.getter(BulkDeploymentMetrics::invalidInputRecords)).setter(BulkDeploymentMetrics.setter(Builder::invalidInputRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidInputRecords").build()}).build();
    private static final SdkField<Integer> RECORDS_PROCESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BulkDeploymentMetrics.getter(BulkDeploymentMetrics::recordsProcessed)).setter(BulkDeploymentMetrics.setter(Builder::recordsProcessed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordsProcessed").build()}).build();
    private static final SdkField<Integer> RETRY_ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BulkDeploymentMetrics.getter(BulkDeploymentMetrics::retryAttempts)).setter(BulkDeploymentMetrics.setter(Builder::retryAttempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryAttempts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALID_INPUT_RECORDS_FIELD, RECORDS_PROCESSED_FIELD, RETRY_ATTEMPTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer invalidInputRecords;
    private final Integer recordsProcessed;
    private final Integer retryAttempts;

    private BulkDeploymentMetrics(BuilderImpl builder) {
        this.invalidInputRecords = builder.invalidInputRecords;
        this.recordsProcessed = builder.recordsProcessed;
        this.retryAttempts = builder.retryAttempts;
    }

    public Integer invalidInputRecords() {
        return this.invalidInputRecords;
    }

    public Integer recordsProcessed() {
        return this.recordsProcessed;
    }

    public Integer retryAttempts() {
        return this.retryAttempts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invalidInputRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordsProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryAttempts());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BulkDeploymentMetrics)) {
            return false;
        }
        BulkDeploymentMetrics other = (BulkDeploymentMetrics)obj;
        return Objects.equals(this.invalidInputRecords(), other.invalidInputRecords()) && Objects.equals(this.recordsProcessed(), other.recordsProcessed()) && Objects.equals(this.retryAttempts(), other.retryAttempts());
    }

    public String toString() {
        return ToString.builder((String)"BulkDeploymentMetrics").add("InvalidInputRecords", (Object)this.invalidInputRecords()).add("RecordsProcessed", (Object)this.recordsProcessed()).add("RetryAttempts", (Object)this.retryAttempts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvalidInputRecords": {
                return Optional.ofNullable(clazz.cast(this.invalidInputRecords()));
            }
            case "RecordsProcessed": {
                return Optional.ofNullable(clazz.cast(this.recordsProcessed()));
            }
            case "RetryAttempts": {
                return Optional.ofNullable(clazz.cast(this.retryAttempts()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BulkDeploymentMetrics, T> g) {
        return obj -> g.apply((BulkDeploymentMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer invalidInputRecords;
        private Integer recordsProcessed;
        private Integer retryAttempts;

        private BuilderImpl() {
        }

        private BuilderImpl(BulkDeploymentMetrics model) {
            this.invalidInputRecords(model.invalidInputRecords);
            this.recordsProcessed(model.recordsProcessed);
            this.retryAttempts(model.retryAttempts);
        }

        public final Integer getInvalidInputRecords() {
            return this.invalidInputRecords;
        }

        @Override
        public final Builder invalidInputRecords(Integer invalidInputRecords) {
            this.invalidInputRecords = invalidInputRecords;
            return this;
        }

        public final void setInvalidInputRecords(Integer invalidInputRecords) {
            this.invalidInputRecords = invalidInputRecords;
        }

        public final Integer getRecordsProcessed() {
            return this.recordsProcessed;
        }

        @Override
        public final Builder recordsProcessed(Integer recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
            return this;
        }

        public final void setRecordsProcessed(Integer recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
        }

        public final Integer getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public final Builder retryAttempts(Integer retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        public final void setRetryAttempts(Integer retryAttempts) {
            this.retryAttempts = retryAttempts;
        }

        public BulkDeploymentMetrics build() {
            return new BulkDeploymentMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BulkDeploymentMetrics> {
        public Builder invalidInputRecords(Integer var1);

        public Builder recordsProcessed(Integer var1);

        public Builder retryAttempts(Integer var1);
    }
}

