/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.services.greengrass.model.SoftwareToUpdate;
import software.amazon.awssdk.services.greengrass.model.UpdateAgentLogLevel;
import software.amazon.awssdk.services.greengrass.model.UpdateTargetsArchitecture;
import software.amazon.awssdk.services.greengrass.model.UpdateTargetsCopier;
import software.amazon.awssdk.services.greengrass.model.UpdateTargetsOperatingSystem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSoftwareUpdateJobRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, CreateSoftwareUpdateJobRequest> {
    private static final SdkField<String> AMZN_CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSoftwareUpdateJobRequest.getter(CreateSoftwareUpdateJobRequest::amznClientToken)).setter(CreateSoftwareUpdateJobRequest.setter(Builder::amznClientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build()}).build();
    private static final SdkField<String> S3_URL_SIGNER_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSoftwareUpdateJobRequest.getter(CreateSoftwareUpdateJobRequest::s3UrlSignerRole)).setter(CreateSoftwareUpdateJobRequest.setter(Builder::s3UrlSignerRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3UrlSignerRole").build()}).build();
    private static final SdkField<String> SOFTWARE_TO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSoftwareUpdateJobRequest.getter(CreateSoftwareUpdateJobRequest::softwareToUpdateAsString)).setter(CreateSoftwareUpdateJobRequest.setter(Builder::softwareToUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareToUpdate").build()}).build();
    private static final SdkField<String> UPDATE_AGENT_LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSoftwareUpdateJobRequest.getter(CreateSoftwareUpdateJobRequest::updateAgentLogLevelAsString)).setter(CreateSoftwareUpdateJobRequest.setter(Builder::updateAgentLogLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateAgentLogLevel").build()}).build();
    private static final SdkField<List<String>> UPDATE_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateSoftwareUpdateJobRequest.getter(CreateSoftwareUpdateJobRequest::updateTargets)).setter(CreateSoftwareUpdateJobRequest.setter(Builder::updateTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UPDATE_TARGETS_ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSoftwareUpdateJobRequest.getter(CreateSoftwareUpdateJobRequest::updateTargetsArchitectureAsString)).setter(CreateSoftwareUpdateJobRequest.setter(Builder::updateTargetsArchitecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTargetsArchitecture").build()}).build();
    private static final SdkField<String> UPDATE_TARGETS_OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSoftwareUpdateJobRequest.getter(CreateSoftwareUpdateJobRequest::updateTargetsOperatingSystemAsString)).setter(CreateSoftwareUpdateJobRequest.setter(Builder::updateTargetsOperatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTargetsOperatingSystem").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMZN_CLIENT_TOKEN_FIELD, S3_URL_SIGNER_ROLE_FIELD, SOFTWARE_TO_UPDATE_FIELD, UPDATE_AGENT_LOG_LEVEL_FIELD, UPDATE_TARGETS_FIELD, UPDATE_TARGETS_ARCHITECTURE_FIELD, UPDATE_TARGETS_OPERATING_SYSTEM_FIELD));
    private final String amznClientToken;
    private final String s3UrlSignerRole;
    private final String softwareToUpdate;
    private final String updateAgentLogLevel;
    private final List<String> updateTargets;
    private final String updateTargetsArchitecture;
    private final String updateTargetsOperatingSystem;

    private CreateSoftwareUpdateJobRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.s3UrlSignerRole = builder.s3UrlSignerRole;
        this.softwareToUpdate = builder.softwareToUpdate;
        this.updateAgentLogLevel = builder.updateAgentLogLevel;
        this.updateTargets = builder.updateTargets;
        this.updateTargetsArchitecture = builder.updateTargetsArchitecture;
        this.updateTargetsOperatingSystem = builder.updateTargetsOperatingSystem;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public String s3UrlSignerRole() {
        return this.s3UrlSignerRole;
    }

    public SoftwareToUpdate softwareToUpdate() {
        return SoftwareToUpdate.fromValue(this.softwareToUpdate);
    }

    public String softwareToUpdateAsString() {
        return this.softwareToUpdate;
    }

    public UpdateAgentLogLevel updateAgentLogLevel() {
        return UpdateAgentLogLevel.fromValue(this.updateAgentLogLevel);
    }

    public String updateAgentLogLevelAsString() {
        return this.updateAgentLogLevel;
    }

    public List<String> updateTargets() {
        return this.updateTargets;
    }

    public UpdateTargetsArchitecture updateTargetsArchitecture() {
        return UpdateTargetsArchitecture.fromValue(this.updateTargetsArchitecture);
    }

    public String updateTargetsArchitectureAsString() {
        return this.updateTargetsArchitecture;
    }

    public UpdateTargetsOperatingSystem updateTargetsOperatingSystem() {
        return UpdateTargetsOperatingSystem.fromValue(this.updateTargetsOperatingSystem);
    }

    public String updateTargetsOperatingSystemAsString() {
        return this.updateTargetsOperatingSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3UrlSignerRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareToUpdateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateAgentLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTargetsArchitectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTargetsOperatingSystemAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSoftwareUpdateJobRequest)) {
            return false;
        }
        CreateSoftwareUpdateJobRequest other = (CreateSoftwareUpdateJobRequest)((Object)obj);
        return Objects.equals(this.amznClientToken(), other.amznClientToken()) && Objects.equals(this.s3UrlSignerRole(), other.s3UrlSignerRole()) && Objects.equals(this.softwareToUpdateAsString(), other.softwareToUpdateAsString()) && Objects.equals(this.updateAgentLogLevelAsString(), other.updateAgentLogLevelAsString()) && Objects.equals(this.updateTargets(), other.updateTargets()) && Objects.equals(this.updateTargetsArchitectureAsString(), other.updateTargetsArchitectureAsString()) && Objects.equals(this.updateTargetsOperatingSystemAsString(), other.updateTargetsOperatingSystemAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateSoftwareUpdateJobRequest").add("AmznClientToken", (Object)this.amznClientToken()).add("S3UrlSignerRole", (Object)this.s3UrlSignerRole()).add("SoftwareToUpdate", (Object)this.softwareToUpdateAsString()).add("UpdateAgentLogLevel", (Object)this.updateAgentLogLevelAsString()).add("UpdateTargets", this.updateTargets()).add("UpdateTargetsArchitecture", (Object)this.updateTargetsArchitectureAsString()).add("UpdateTargetsOperatingSystem", (Object)this.updateTargetsOperatingSystemAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.ofNullable(clazz.cast(this.amznClientToken()));
            }
            case "S3UrlSignerRole": {
                return Optional.ofNullable(clazz.cast(this.s3UrlSignerRole()));
            }
            case "SoftwareToUpdate": {
                return Optional.ofNullable(clazz.cast(this.softwareToUpdateAsString()));
            }
            case "UpdateAgentLogLevel": {
                return Optional.ofNullable(clazz.cast(this.updateAgentLogLevelAsString()));
            }
            case "UpdateTargets": {
                return Optional.ofNullable(clazz.cast(this.updateTargets()));
            }
            case "UpdateTargetsArchitecture": {
                return Optional.ofNullable(clazz.cast(this.updateTargetsArchitectureAsString()));
            }
            case "UpdateTargetsOperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.updateTargetsOperatingSystemAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSoftwareUpdateJobRequest, T> g) {
        return obj -> g.apply((CreateSoftwareUpdateJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String amznClientToken;
        private String s3UrlSignerRole;
        private String softwareToUpdate;
        private String updateAgentLogLevel;
        private List<String> updateTargets = DefaultSdkAutoConstructList.getInstance();
        private String updateTargetsArchitecture;
        private String updateTargetsOperatingSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSoftwareUpdateJobRequest model) {
            super(model);
            this.amznClientToken(model.amznClientToken);
            this.s3UrlSignerRole(model.s3UrlSignerRole);
            this.softwareToUpdate(model.softwareToUpdate);
            this.updateAgentLogLevel(model.updateAgentLogLevel);
            this.updateTargets(model.updateTargets);
            this.updateTargetsArchitecture(model.updateTargetsArchitecture);
            this.updateTargetsOperatingSystem(model.updateTargetsOperatingSystem);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getS3UrlSignerRole() {
            return this.s3UrlSignerRole;
        }

        @Override
        public final Builder s3UrlSignerRole(String s3UrlSignerRole) {
            this.s3UrlSignerRole = s3UrlSignerRole;
            return this;
        }

        public final void setS3UrlSignerRole(String s3UrlSignerRole) {
            this.s3UrlSignerRole = s3UrlSignerRole;
        }

        public final String getSoftwareToUpdateAsString() {
            return this.softwareToUpdate;
        }

        @Override
        public final Builder softwareToUpdate(String softwareToUpdate) {
            this.softwareToUpdate = softwareToUpdate;
            return this;
        }

        @Override
        public final Builder softwareToUpdate(SoftwareToUpdate softwareToUpdate) {
            this.softwareToUpdate(softwareToUpdate.toString());
            return this;
        }

        public final void setSoftwareToUpdate(String softwareToUpdate) {
            this.softwareToUpdate = softwareToUpdate;
        }

        public final String getUpdateAgentLogLevelAsString() {
            return this.updateAgentLogLevel;
        }

        @Override
        public final Builder updateAgentLogLevel(String updateAgentLogLevel) {
            this.updateAgentLogLevel = updateAgentLogLevel;
            return this;
        }

        @Override
        public final Builder updateAgentLogLevel(UpdateAgentLogLevel updateAgentLogLevel) {
            this.updateAgentLogLevel(updateAgentLogLevel.toString());
            return this;
        }

        public final void setUpdateAgentLogLevel(String updateAgentLogLevel) {
            this.updateAgentLogLevel = updateAgentLogLevel;
        }

        public final Collection<String> getUpdateTargets() {
            return this.updateTargets;
        }

        @Override
        public final Builder updateTargets(Collection<String> updateTargets) {
            this.updateTargets = UpdateTargetsCopier.copy(updateTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateTargets(String ... updateTargets) {
            this.updateTargets(Arrays.asList(updateTargets));
            return this;
        }

        public final void setUpdateTargets(Collection<String> updateTargets) {
            this.updateTargets = UpdateTargetsCopier.copy(updateTargets);
        }

        public final String getUpdateTargetsArchitectureAsString() {
            return this.updateTargetsArchitecture;
        }

        @Override
        public final Builder updateTargetsArchitecture(String updateTargetsArchitecture) {
            this.updateTargetsArchitecture = updateTargetsArchitecture;
            return this;
        }

        @Override
        public final Builder updateTargetsArchitecture(UpdateTargetsArchitecture updateTargetsArchitecture) {
            this.updateTargetsArchitecture(updateTargetsArchitecture.toString());
            return this;
        }

        public final void setUpdateTargetsArchitecture(String updateTargetsArchitecture) {
            this.updateTargetsArchitecture = updateTargetsArchitecture;
        }

        public final String getUpdateTargetsOperatingSystemAsString() {
            return this.updateTargetsOperatingSystem;
        }

        @Override
        public final Builder updateTargetsOperatingSystem(String updateTargetsOperatingSystem) {
            this.updateTargetsOperatingSystem = updateTargetsOperatingSystem;
            return this;
        }

        @Override
        public final Builder updateTargetsOperatingSystem(UpdateTargetsOperatingSystem updateTargetsOperatingSystem) {
            this.updateTargetsOperatingSystem(updateTargetsOperatingSystem.toString());
            return this;
        }

        public final void setUpdateTargetsOperatingSystem(String updateTargetsOperatingSystem) {
            this.updateTargetsOperatingSystem = updateTargetsOperatingSystem;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSoftwareUpdateJobRequest build() {
            return new CreateSoftwareUpdateJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSoftwareUpdateJobRequest> {
        public Builder amznClientToken(String var1);

        public Builder s3UrlSignerRole(String var1);

        public Builder softwareToUpdate(String var1);

        public Builder softwareToUpdate(SoftwareToUpdate var1);

        public Builder updateAgentLogLevel(String var1);

        public Builder updateAgentLogLevel(UpdateAgentLogLevel var1);

        public Builder updateTargets(Collection<String> var1);

        public Builder updateTargets(String ... var1);

        public Builder updateTargetsArchitecture(String var1);

        public Builder updateTargetsArchitecture(UpdateTargetsArchitecture var1);

        public Builder updateTargetsOperatingSystem(String var1);

        public Builder updateTargetsOperatingSystem(UpdateTargetsOperatingSystem var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

