/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrass.model.ResourceDownloadOwnerSetting;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3MachineLearningModelResourceData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3MachineLearningModelResourceData> {
    private static final SdkField<String> DESTINATION_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPath").getter(S3MachineLearningModelResourceData.getter(S3MachineLearningModelResourceData::destinationPath)).setter(S3MachineLearningModelResourceData.setter(Builder::destinationPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPath").build()}).build();
    private static final SdkField<ResourceDownloadOwnerSetting> OWNER_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OwnerSetting").getter(S3MachineLearningModelResourceData.getter(S3MachineLearningModelResourceData::ownerSetting)).setter(S3MachineLearningModelResourceData.setter(Builder::ownerSetting)).constructor(ResourceDownloadOwnerSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerSetting").build()}).build();
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Uri").getter(S3MachineLearningModelResourceData.getter(S3MachineLearningModelResourceData::s3Uri)).setter(S3MachineLearningModelResourceData.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_PATH_FIELD, OWNER_SETTING_FIELD, S3_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DestinationPath", DESTINATION_PATH_FIELD);
            this.put("OwnerSetting", OWNER_SETTING_FIELD);
            this.put("S3Uri", S3_URI_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String destinationPath;
    private final ResourceDownloadOwnerSetting ownerSetting;
    private final String s3Uri;

    private S3MachineLearningModelResourceData(BuilderImpl builder) {
        this.destinationPath = builder.destinationPath;
        this.ownerSetting = builder.ownerSetting;
        this.s3Uri = builder.s3Uri;
    }

    public final String destinationPath() {
        return this.destinationPath;
    }

    public final ResourceDownloadOwnerSetting ownerSetting() {
        return this.ownerSetting;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3MachineLearningModelResourceData)) {
            return false;
        }
        S3MachineLearningModelResourceData other = (S3MachineLearningModelResourceData)obj;
        return Objects.equals(this.destinationPath(), other.destinationPath()) && Objects.equals(this.ownerSetting(), other.ownerSetting()) && Objects.equals(this.s3Uri(), other.s3Uri());
    }

    public final String toString() {
        return ToString.builder((String)"S3MachineLearningModelResourceData").add("DestinationPath", (Object)this.destinationPath()).add("OwnerSetting", (Object)this.ownerSetting()).add("S3Uri", (Object)this.s3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationPath": {
                return Optional.ofNullable(clazz.cast(this.destinationPath()));
            }
            case "OwnerSetting": {
                return Optional.ofNullable(clazz.cast(this.ownerSetting()));
            }
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3MachineLearningModelResourceData, T> g) {
        return obj -> g.apply((S3MachineLearningModelResourceData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationPath;
        private ResourceDownloadOwnerSetting ownerSetting;
        private String s3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(S3MachineLearningModelResourceData model) {
            this.destinationPath(model.destinationPath);
            this.ownerSetting(model.ownerSetting);
            this.s3Uri(model.s3Uri);
        }

        public final String getDestinationPath() {
            return this.destinationPath;
        }

        public final void setDestinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
        }

        @Override
        public final Builder destinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
            return this;
        }

        public final ResourceDownloadOwnerSetting.Builder getOwnerSetting() {
            return this.ownerSetting != null ? this.ownerSetting.toBuilder() : null;
        }

        public final void setOwnerSetting(ResourceDownloadOwnerSetting.BuilderImpl ownerSetting) {
            this.ownerSetting = ownerSetting != null ? ownerSetting.build() : null;
        }

        @Override
        public final Builder ownerSetting(ResourceDownloadOwnerSetting ownerSetting) {
            this.ownerSetting = ownerSetting;
            return this;
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public S3MachineLearningModelResourceData build() {
            return new S3MachineLearningModelResourceData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3MachineLearningModelResourceData> {
        public Builder destinationPath(String var1);

        public Builder ownerSetting(ResourceDownloadOwnerSetting var1);

        default public Builder ownerSetting(Consumer<ResourceDownloadOwnerSetting.Builder> ownerSetting) {
            return this.ownerSetting((ResourceDownloadOwnerSetting)((ResourceDownloadOwnerSetting.Builder)ResourceDownloadOwnerSetting.builder().applyMutation(ownerSetting)).build());
        }

        public Builder s3Uri(String var1);
    }
}

