/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FunctionIsolationMode {
    GREENGRASS_CONTAINER("GreengrassContainer"),
    NO_CONTAINER("NoContainer"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FunctionIsolationMode> VALUE_MAP;
    private final String value;

    private FunctionIsolationMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FunctionIsolationMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FunctionIsolationMode> knownValues() {
        EnumSet<FunctionIsolationMode> knownValues = EnumSet.allOf(FunctionIsolationMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FunctionIsolationMode.class, FunctionIsolationMode::toString);
    }
}

