/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.greengrass.DefaultGreengrassBaseClientBuilder;
import software.amazon.awssdk.services.greengrass.DefaultGreengrassClient;
import software.amazon.awssdk.services.greengrass.GreengrassClient;
import software.amazon.awssdk.services.greengrass.GreengrassClientBuilder;
import software.amazon.awssdk.services.greengrass.GreengrassServiceClientConfiguration;
import software.amazon.awssdk.services.greengrass.endpoints.GreengrassEndpointProvider;

@SdkInternalApi
final class DefaultGreengrassClientBuilder
extends DefaultGreengrassBaseClientBuilder<GreengrassClientBuilder, GreengrassClient>
implements GreengrassClientBuilder {
    DefaultGreengrassClientBuilder() {
    }

    @Override
    public DefaultGreengrassClientBuilder endpointProvider(GreengrassEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GreengrassClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultGreengrassClientBuilder.validateClientOptions(clientConfiguration);
        GreengrassServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultGreengrassClient client = new DefaultGreengrassClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private GreengrassServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return GreengrassServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

