/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopBulkDeploymentRequest extends GreengrassRequest implements
        ToCopyableBuilder<StopBulkDeploymentRequest.Builder, StopBulkDeploymentRequest> {
    private static final SdkField<String> BULK_DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BulkDeploymentId").getter(getter(StopBulkDeploymentRequest::bulkDeploymentId))
            .setter(setter(Builder::bulkDeploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("BulkDeploymentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BULK_DEPLOYMENT_ID_FIELD));

    private final String bulkDeploymentId;

    private StopBulkDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.bulkDeploymentId = builder.bulkDeploymentId;
    }

    /**
     * The ID of the bulk deployment.
     * 
     * @return The ID of the bulk deployment.
     */
    public final String bulkDeploymentId() {
        return bulkDeploymentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bulkDeploymentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopBulkDeploymentRequest)) {
            return false;
        }
        StopBulkDeploymentRequest other = (StopBulkDeploymentRequest) obj;
        return Objects.equals(bulkDeploymentId(), other.bulkDeploymentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopBulkDeploymentRequest").add("BulkDeploymentId", bulkDeploymentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BulkDeploymentId":
            return Optional.ofNullable(clazz.cast(bulkDeploymentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopBulkDeploymentRequest, T> g) {
        return obj -> g.apply((StopBulkDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopBulkDeploymentRequest> {
        /**
         * The ID of the bulk deployment.
         * 
         * @param bulkDeploymentId
         *        The ID of the bulk deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bulkDeploymentId(String bulkDeploymentId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String bulkDeploymentId;

        private BuilderImpl() {
        }

        private BuilderImpl(StopBulkDeploymentRequest model) {
            super(model);
            bulkDeploymentId(model.bulkDeploymentId);
        }

        public final String getBulkDeploymentId() {
            return bulkDeploymentId;
        }

        @Override
        public final Builder bulkDeploymentId(String bulkDeploymentId) {
            this.bulkDeploymentId = bulkDeploymentId;
            return this;
        }

        public final void setBulkDeploymentId(String bulkDeploymentId) {
            this.bulkDeploymentId = bulkDeploymentId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopBulkDeploymentRequest build() {
            return new StopBulkDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
