/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartBulkDeploymentRequest extends GreengrassRequest implements
        ToCopyableBuilder<StartBulkDeploymentRequest.Builder, StartBulkDeploymentRequest> {
    private static final SdkField<String> AMZN_CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmznClientToken").getter(getter(StartBulkDeploymentRequest::amznClientToken))
            .setter(setter(Builder::amznClientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build())
            .build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(StartBulkDeploymentRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<String> INPUT_FILE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputFileUri").getter(getter(StartBulkDeploymentRequest::inputFileUri))
            .setter(setter(Builder::inputFileUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFileUri").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StartBulkDeploymentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMZN_CLIENT_TOKEN_FIELD,
            EXECUTION_ROLE_ARN_FIELD, INPUT_FILE_URI_FIELD, TAGS_FIELD));

    private final String amznClientToken;

    private final String executionRoleArn;

    private final String inputFileUri;

    private final Map<String, String> tags;

    private StartBulkDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.executionRoleArn = builder.executionRoleArn;
        this.inputFileUri = builder.inputFileUri;
        this.tags = builder.tags;
    }

    /**
     * A client token used to correlate requests and responses.
     * 
     * @return A client token used to correlate requests and responses.
     */
    public final String amznClientToken() {
        return amznClientToken;
    }

    /**
     * The ARN of the execution role to associate with the bulk deployment operation. This IAM role must allow the
     * ''greengrass:CreateDeployment'' action for all group versions that are listed in the input file. This IAM role
     * must have access to the S3 bucket containing the input file.
     * 
     * @return The ARN of the execution role to associate with the bulk deployment operation. This IAM role must allow
     *         the ''greengrass:CreateDeployment'' action for all group versions that are listed in the input file. This
     *         IAM role must have access to the S3 bucket containing the input file.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * The URI of the input file contained in the S3 bucket. The execution role must have ''getObject'' permissions on
     * this bucket to access the input file. The input file is a JSON-serialized, line delimited file with UTF-8
     * encoding that provides a list of group and version IDs and the deployment type. This file must be less than 100
     * MB. Currently, AWS IoT Greengrass supports only ''NewDeployment'' deployment types.
     * 
     * @return The URI of the input file contained in the S3 bucket. The execution role must have ''getObject''
     *         permissions on this bucket to access the input file. The input file is a JSON-serialized, line delimited
     *         file with UTF-8 encoding that provides a list of group and version IDs and the deployment type. This file
     *         must be less than 100 MB. Currently, AWS IoT Greengrass supports only ''NewDeployment'' deployment types.
     */
    public final String inputFileUri() {
        return inputFileUri;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Tag(s) to add to the new resource.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tag(s) to add to the new resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(inputFileUri());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBulkDeploymentRequest)) {
            return false;
        }
        StartBulkDeploymentRequest other = (StartBulkDeploymentRequest) obj;
        return Objects.equals(amznClientToken(), other.amznClientToken())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(inputFileUri(), other.inputFileUri()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartBulkDeploymentRequest").add("AmznClientToken", amznClientToken())
                .add("ExecutionRoleArn", executionRoleArn()).add("InputFileUri", inputFileUri())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmznClientToken":
            return Optional.ofNullable(clazz.cast(amznClientToken()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "InputFileUri":
            return Optional.ofNullable(clazz.cast(inputFileUri()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartBulkDeploymentRequest, T> g) {
        return obj -> g.apply((StartBulkDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartBulkDeploymentRequest> {
        /**
         * A client token used to correlate requests and responses.
         * 
         * @param amznClientToken
         *        A client token used to correlate requests and responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amznClientToken(String amznClientToken);

        /**
         * The ARN of the execution role to associate with the bulk deployment operation. This IAM role must allow the
         * ''greengrass:CreateDeployment'' action for all group versions that are listed in the input file. This IAM
         * role must have access to the S3 bucket containing the input file.
         * 
         * @param executionRoleArn
         *        The ARN of the execution role to associate with the bulk deployment operation. This IAM role must
         *        allow the ''greengrass:CreateDeployment'' action for all group versions that are listed in the input
         *        file. This IAM role must have access to the S3 bucket containing the input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * The URI of the input file contained in the S3 bucket. The execution role must have ''getObject'' permissions
         * on this bucket to access the input file. The input file is a JSON-serialized, line delimited file with UTF-8
         * encoding that provides a list of group and version IDs and the deployment type. This file must be less than
         * 100 MB. Currently, AWS IoT Greengrass supports only ''NewDeployment'' deployment types.
         * 
         * @param inputFileUri
         *        The URI of the input file contained in the S3 bucket. The execution role must have ''getObject''
         *        permissions on this bucket to access the input file. The input file is a JSON-serialized, line
         *        delimited file with UTF-8 encoding that provides a list of group and version IDs and the deployment
         *        type. This file must be less than 100 MB. Currently, AWS IoT Greengrass supports only
         *        ''NewDeployment'' deployment types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputFileUri(String inputFileUri);

        /**
         * Tag(s) to add to the new resource.
         * 
         * @param tags
         *        Tag(s) to add to the new resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String amznClientToken;

        private String executionRoleArn;

        private String inputFileUri;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartBulkDeploymentRequest model) {
            super(model);
            amznClientToken(model.amznClientToken);
            executionRoleArn(model.executionRoleArn);
            inputFileUri(model.inputFileUri);
            tags(model.tags);
        }

        public final String getAmznClientToken() {
            return amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final String getInputFileUri() {
            return inputFileUri;
        }

        @Override
        public final Builder inputFileUri(String inputFileUri) {
            this.inputFileUri = inputFileUri;
            return this;
        }

        public final void setInputFileUri(String inputFileUri) {
            this.inputFileUri = inputFileUri;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartBulkDeploymentRequest build() {
            return new StartBulkDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
