/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConnectivityInfoResponse extends GreengrassResponse implements
        ToCopyableBuilder<GetConnectivityInfoResponse.Builder, GetConnectivityInfoResponse> {
    private static final SdkField<List<ConnectivityInfo>> CONNECTIVITY_INFO_FIELD = SdkField
            .<List<ConnectivityInfo>> builder(MarshallingType.LIST)
            .memberName("ConnectivityInfo")
            .getter(getter(GetConnectivityInfoResponse::connectivityInfo))
            .setter(setter(Builder::connectivityInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectivityInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectivityInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectivityInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(GetConnectivityInfoResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTIVITY_INFO_FIELD,
            MESSAGE_FIELD));

    private final List<ConnectivityInfo> connectivityInfo;

    private final String message;

    private GetConnectivityInfoResponse(BuilderImpl builder) {
        super(builder);
        this.connectivityInfo = builder.connectivityInfo;
        this.message = builder.message;
    }

    /**
     * Returns true if the ConnectivityInfo property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasConnectivityInfo() {
        return connectivityInfo != null && !(connectivityInfo instanceof SdkAutoConstructList);
    }

    /**
     * Connectivity info list.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConnectivityInfo()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Connectivity info list.
     */
    public final List<ConnectivityInfo> connectivityInfo() {
        return connectivityInfo;
    }

    /**
     * A message about the connectivity info request.
     * 
     * @return A message about the connectivity info request.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectivityInfo() ? connectivityInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectivityInfoResponse)) {
            return false;
        }
        GetConnectivityInfoResponse other = (GetConnectivityInfoResponse) obj;
        return hasConnectivityInfo() == other.hasConnectivityInfo()
                && Objects.equals(connectivityInfo(), other.connectivityInfo()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConnectivityInfoResponse")
                .add("ConnectivityInfo", hasConnectivityInfo() ? connectivityInfo() : null).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectivityInfo":
            return Optional.ofNullable(clazz.cast(connectivityInfo()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConnectivityInfoResponse, T> g) {
        return obj -> g.apply((GetConnectivityInfoResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetConnectivityInfoResponse> {
        /**
         * Connectivity info list.
         * 
         * @param connectivityInfo
         *        Connectivity info list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectivityInfo(Collection<ConnectivityInfo> connectivityInfo);

        /**
         * Connectivity info list.
         * 
         * @param connectivityInfo
         *        Connectivity info list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectivityInfo(ConnectivityInfo... connectivityInfo);

        /**
         * Connectivity info list. This is a convenience that creates an instance of the {@link List
         * <ConnectivityInfo>.Builder} avoiding the need to create one manually via {@link List
         * <ConnectivityInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConnectivityInfo>.Builder#build()} is called immediately and
         * its result is passed to {@link #connectivityInfo(List<ConnectivityInfo>)}.
         * 
         * @param connectivityInfo
         *        a consumer that will call methods on {@link List<ConnectivityInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectivityInfo(List<ConnectivityInfo>)
         */
        Builder connectivityInfo(Consumer<ConnectivityInfo.Builder>... connectivityInfo);

        /**
         * A message about the connectivity info request.
         * 
         * @param message
         *        A message about the connectivity info request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private List<ConnectivityInfo> connectivityInfo = DefaultSdkAutoConstructList.getInstance();

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectivityInfoResponse model) {
            super(model);
            connectivityInfo(model.connectivityInfo);
            message(model.message);
        }

        public final Collection<ConnectivityInfo.Builder> getConnectivityInfo() {
            if (connectivityInfo instanceof SdkAutoConstructList) {
                return null;
            }
            return connectivityInfo != null ? connectivityInfo.stream().map(ConnectivityInfo::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder connectivityInfo(Collection<ConnectivityInfo> connectivityInfo) {
            this.connectivityInfo = ___listOfConnectivityInfoCopier.copy(connectivityInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectivityInfo(ConnectivityInfo... connectivityInfo) {
            connectivityInfo(Arrays.asList(connectivityInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectivityInfo(Consumer<ConnectivityInfo.Builder>... connectivityInfo) {
            connectivityInfo(Stream.of(connectivityInfo).map(c -> ConnectivityInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConnectivityInfo(Collection<ConnectivityInfo.BuilderImpl> connectivityInfo) {
            this.connectivityInfo = ___listOfConnectivityInfoCopier.copyFromBuilder(connectivityInfo);
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public GetConnectivityInfoResponse build() {
            return new GetConnectivityInfoResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
