/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrass.model.Function;
import software.amazon.awssdk.services.greengrass.model.FunctionDefaultConfig;
import software.amazon.awssdk.services.greengrass.model.___listOfFunctionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionDefinitionVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunctionDefinitionVersion> {
    private static final SdkField<FunctionDefaultConfig> DEFAULT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultConfig").getter(FunctionDefinitionVersion.getter(FunctionDefinitionVersion::defaultConfig)).setter(FunctionDefinitionVersion.setter(Builder::defaultConfig)).constructor(FunctionDefaultConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultConfig").build()}).build();
    private static final SdkField<List<Function>> FUNCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Functions").getter(FunctionDefinitionVersion.getter(FunctionDefinitionVersion::functions)).setter(FunctionDefinitionVersion.setter(Builder::functions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Functions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Function::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_CONFIG_FIELD, FUNCTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final FunctionDefaultConfig defaultConfig;
    private final List<Function> functions;

    private FunctionDefinitionVersion(BuilderImpl builder) {
        this.defaultConfig = builder.defaultConfig;
        this.functions = builder.functions;
    }

    public FunctionDefaultConfig defaultConfig() {
        return this.defaultConfig;
    }

    public boolean hasFunctions() {
        return this.functions != null && !(this.functions instanceof SdkAutoConstructList);
    }

    public List<Function> functions() {
        return this.functions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.functions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionDefinitionVersion)) {
            return false;
        }
        FunctionDefinitionVersion other = (FunctionDefinitionVersion)obj;
        return Objects.equals(this.defaultConfig(), other.defaultConfig()) && Objects.equals(this.functions(), other.functions());
    }

    public String toString() {
        return ToString.builder((String)"FunctionDefinitionVersion").add("DefaultConfig", (Object)this.defaultConfig()).add("Functions", this.functions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultConfig": {
                return Optional.ofNullable(clazz.cast(this.defaultConfig()));
            }
            case "Functions": {
                return Optional.ofNullable(clazz.cast(this.functions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> java.util.function.Function<Object, T> getter(java.util.function.Function<FunctionDefinitionVersion, T> g) {
        return obj -> g.apply((FunctionDefinitionVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FunctionDefaultConfig defaultConfig;
        private List<Function> functions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionDefinitionVersion model) {
            this.defaultConfig(model.defaultConfig);
            this.functions(model.functions);
        }

        public final FunctionDefaultConfig.Builder getDefaultConfig() {
            return this.defaultConfig != null ? this.defaultConfig.toBuilder() : null;
        }

        @Override
        public final Builder defaultConfig(FunctionDefaultConfig defaultConfig) {
            this.defaultConfig = defaultConfig;
            return this;
        }

        public final void setDefaultConfig(FunctionDefaultConfig.BuilderImpl defaultConfig) {
            this.defaultConfig = defaultConfig != null ? defaultConfig.build() : null;
        }

        public final Collection<Function.Builder> getFunctions() {
            return this.functions != null ? (Collection)this.functions.stream().map(Function::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder functions(Collection<Function> functions) {
            this.functions = ___listOfFunctionCopier.copy(functions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(Function ... functions) {
            this.functions(Arrays.asList(functions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(Consumer<Function.Builder> ... functions) {
            this.functions(Stream.of(functions).map(c -> (Function)((Function.Builder)Function.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFunctions(Collection<Function.BuilderImpl> functions) {
            this.functions = ___listOfFunctionCopier.copyFromBuilder(functions);
        }

        public FunctionDefinitionVersion build() {
            return new FunctionDefinitionVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunctionDefinitionVersion> {
        public Builder defaultConfig(FunctionDefaultConfig var1);

        default public Builder defaultConfig(Consumer<FunctionDefaultConfig.Builder> defaultConfig) {
            return this.defaultConfig((FunctionDefaultConfig)((FunctionDefaultConfig.Builder)FunctionDefaultConfig.builder().applyMutation(defaultConfig)).build());
        }

        public Builder functions(Collection<Function> var1);

        public Builder functions(Function ... var1);

        public Builder functions(Consumer<Function.Builder> ... var1);
    }
}

