/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.services.greengrass.model.Logger;
import software.amazon.awssdk.services.greengrass.model.___listOfLoggerCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLoggerDefinitionVersionRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, CreateLoggerDefinitionVersionRequest> {
    private static final SdkField<String> AMZN_CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmznClientToken").getter(CreateLoggerDefinitionVersionRequest.getter(CreateLoggerDefinitionVersionRequest::amznClientToken)).setter(CreateLoggerDefinitionVersionRequest.setter(Builder::amznClientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build()}).build();
    private static final SdkField<String> LOGGER_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoggerDefinitionId").getter(CreateLoggerDefinitionVersionRequest.getter(CreateLoggerDefinitionVersionRequest::loggerDefinitionId)).setter(CreateLoggerDefinitionVersionRequest.setter(Builder::loggerDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("LoggerDefinitionId").build()}).build();
    private static final SdkField<List<Logger>> LOGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Loggers").getter(CreateLoggerDefinitionVersionRequest.getter(CreateLoggerDefinitionVersionRequest::loggers)).setter(CreateLoggerDefinitionVersionRequest.setter(Builder::loggers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Loggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Logger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMZN_CLIENT_TOKEN_FIELD, LOGGER_DEFINITION_ID_FIELD, LOGGERS_FIELD));
    private final String amznClientToken;
    private final String loggerDefinitionId;
    private final List<Logger> loggers;

    private CreateLoggerDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.loggerDefinitionId = builder.loggerDefinitionId;
        this.loggers = builder.loggers;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public String loggerDefinitionId() {
        return this.loggerDefinitionId;
    }

    public boolean hasLoggers() {
        return this.loggers != null && !(this.loggers instanceof SdkAutoConstructList);
    }

    public List<Logger> loggers() {
        return this.loggers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggerDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoggerDefinitionVersionRequest)) {
            return false;
        }
        CreateLoggerDefinitionVersionRequest other = (CreateLoggerDefinitionVersionRequest)((Object)obj);
        return Objects.equals(this.amznClientToken(), other.amznClientToken()) && Objects.equals(this.loggerDefinitionId(), other.loggerDefinitionId()) && Objects.equals(this.loggers(), other.loggers());
    }

    public String toString() {
        return ToString.builder((String)"CreateLoggerDefinitionVersionRequest").add("AmznClientToken", (Object)this.amznClientToken()).add("LoggerDefinitionId", (Object)this.loggerDefinitionId()).add("Loggers", this.loggers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.ofNullable(clazz.cast(this.amznClientToken()));
            }
            case "LoggerDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.loggerDefinitionId()));
            }
            case "Loggers": {
                return Optional.ofNullable(clazz.cast(this.loggers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLoggerDefinitionVersionRequest, T> g) {
        return obj -> g.apply((CreateLoggerDefinitionVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String amznClientToken;
        private String loggerDefinitionId;
        private List<Logger> loggers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoggerDefinitionVersionRequest model) {
            super(model);
            this.amznClientToken(model.amznClientToken);
            this.loggerDefinitionId(model.loggerDefinitionId);
            this.loggers(model.loggers);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getLoggerDefinitionId() {
            return this.loggerDefinitionId;
        }

        @Override
        public final Builder loggerDefinitionId(String loggerDefinitionId) {
            this.loggerDefinitionId = loggerDefinitionId;
            return this;
        }

        public final void setLoggerDefinitionId(String loggerDefinitionId) {
            this.loggerDefinitionId = loggerDefinitionId;
        }

        public final Collection<Logger.Builder> getLoggers() {
            return this.loggers != null ? (Collection)this.loggers.stream().map(Logger::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loggers(Collection<Logger> loggers) {
            this.loggers = ___listOfLoggerCopier.copy(loggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggers(Logger ... loggers) {
            this.loggers(Arrays.asList(loggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggers(Consumer<Logger.Builder> ... loggers) {
            this.loggers(Stream.of(loggers).map(c -> (Logger)((Logger.Builder)Logger.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoggers(Collection<Logger.BuilderImpl> loggers) {
            this.loggers = ___listOfLoggerCopier.copyFromBuilder(loggers);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLoggerDefinitionVersionRequest build() {
            return new CreateLoggerDefinitionVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLoggerDefinitionVersionRequest> {
        public Builder amznClientToken(String var1);

        public Builder loggerDefinitionId(String var1);

        public Builder loggers(Collection<Logger> var1);

        public Builder loggers(Logger ... var1);

        public Builder loggers(Consumer<Logger.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

