/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Connectivity information.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectivityInfoRequest extends GreengrassRequest implements
        ToCopyableBuilder<UpdateConnectivityInfoRequest.Builder, UpdateConnectivityInfoRequest> {
    private static final SdkField<List<ConnectivityInfo>> CONNECTIVITY_INFO_FIELD = SdkField
            .<List<ConnectivityInfo>> builder(MarshallingType.LIST)
            .getter(getter(UpdateConnectivityInfoRequest::connectivityInfo))
            .setter(setter(Builder::connectivityInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectivityInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectivityInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectivityInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateConnectivityInfoRequest::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ThingName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTIVITY_INFO_FIELD,
            THING_NAME_FIELD));

    private final List<ConnectivityInfo> connectivityInfo;

    private final String thingName;

    private UpdateConnectivityInfoRequest(BuilderImpl builder) {
        super(builder);
        this.connectivityInfo = builder.connectivityInfo;
        this.thingName = builder.thingName;
    }

    /**
     * Returns true if the ConnectivityInfo property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasConnectivityInfo() {
        return connectivityInfo != null && !(connectivityInfo instanceof SdkAutoConstructList);
    }

    /**
     * A list of connectivity info.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConnectivityInfo()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of connectivity info.
     */
    public List<ConnectivityInfo> connectivityInfo() {
        return connectivityInfo;
    }

    /**
     * The thing name.
     * 
     * @return The thing name.
     */
    public String thingName() {
        return thingName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectivityInfo());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectivityInfoRequest)) {
            return false;
        }
        UpdateConnectivityInfoRequest other = (UpdateConnectivityInfoRequest) obj;
        return Objects.equals(connectivityInfo(), other.connectivityInfo()) && Objects.equals(thingName(), other.thingName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateConnectivityInfoRequest").add("ConnectivityInfo", connectivityInfo())
                .add("ThingName", thingName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectivityInfo":
            return Optional.ofNullable(clazz.cast(connectivityInfo()));
        case "ThingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectivityInfoRequest, T> g) {
        return obj -> g.apply((UpdateConnectivityInfoRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConnectivityInfoRequest> {
        /**
         * A list of connectivity info.
         * 
         * @param connectivityInfo
         *        A list of connectivity info.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectivityInfo(Collection<ConnectivityInfo> connectivityInfo);

        /**
         * A list of connectivity info.
         * 
         * @param connectivityInfo
         *        A list of connectivity info.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectivityInfo(ConnectivityInfo... connectivityInfo);

        /**
         * A list of connectivity info. This is a convenience that creates an instance of the {@link List
         * <ConnectivityInfo>.Builder} avoiding the need to create one manually via {@link List
         * <ConnectivityInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConnectivityInfo>.Builder#build()} is called immediately and
         * its result is passed to {@link #connectivityInfo(List<ConnectivityInfo>)}.
         * 
         * @param connectivityInfo
         *        a consumer that will call methods on {@link List<ConnectivityInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectivityInfo(List<ConnectivityInfo>)
         */
        Builder connectivityInfo(Consumer<ConnectivityInfo.Builder>... connectivityInfo);

        /**
         * The thing name.
         * 
         * @param thingName
         *        The thing name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private List<ConnectivityInfo> connectivityInfo = DefaultSdkAutoConstructList.getInstance();

        private String thingName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectivityInfoRequest model) {
            super(model);
            connectivityInfo(model.connectivityInfo);
            thingName(model.thingName);
        }

        public final Collection<ConnectivityInfo.Builder> getConnectivityInfo() {
            return connectivityInfo != null ? connectivityInfo.stream().map(ConnectivityInfo::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder connectivityInfo(Collection<ConnectivityInfo> connectivityInfo) {
            this.connectivityInfo = ___listOfConnectivityInfoCopier.copy(connectivityInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectivityInfo(ConnectivityInfo... connectivityInfo) {
            connectivityInfo(Arrays.asList(connectivityInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectivityInfo(Consumer<ConnectivityInfo.Builder>... connectivityInfo) {
            connectivityInfo(Stream.of(connectivityInfo).map(c -> ConnectivityInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConnectivityInfo(Collection<ConnectivityInfo.BuilderImpl> connectivityInfo) {
            this.connectivityInfo = ___listOfConnectivityInfoCopier.copyFromBuilder(connectivityInfo);
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectivityInfoRequest build() {
            return new UpdateConnectivityInfoRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
