/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about a subscription definition version.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubscriptionDefinitionVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<SubscriptionDefinitionVersion.Builder, SubscriptionDefinitionVersion> {
    private static final SdkField<List<Subscription>> SUBSCRIPTIONS_FIELD = SdkField
            .<List<Subscription>> builder(MarshallingType.LIST)
            .getter(getter(SubscriptionDefinitionVersion::subscriptions))
            .setter(setter(Builder::subscriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Subscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(Subscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Subscription> subscriptions;

    private SubscriptionDefinitionVersion(BuilderImpl builder) {
        this.subscriptions = builder.subscriptions;
    }

    /**
     * Returns true if the Subscriptions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubscriptions() {
        return subscriptions != null && !(subscriptions instanceof SdkAutoConstructList);
    }

    /**
     * A list of subscriptions.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubscriptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of subscriptions.
     */
    public List<Subscription> subscriptions() {
        return subscriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subscriptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscriptionDefinitionVersion)) {
            return false;
        }
        SubscriptionDefinitionVersion other = (SubscriptionDefinitionVersion) obj;
        return Objects.equals(subscriptions(), other.subscriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SubscriptionDefinitionVersion").add("Subscriptions", subscriptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subscriptions":
            return Optional.ofNullable(clazz.cast(subscriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubscriptionDefinitionVersion, T> g) {
        return obj -> g.apply((SubscriptionDefinitionVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubscriptionDefinitionVersion> {
        /**
         * A list of subscriptions.
         * 
         * @param subscriptions
         *        A list of subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptions(Collection<Subscription> subscriptions);

        /**
         * A list of subscriptions.
         * 
         * @param subscriptions
         *        A list of subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptions(Subscription... subscriptions);

        /**
         * A list of subscriptions. This is a convenience that creates an instance of the {@link List
         * <Subscription>.Builder} avoiding the need to create one manually via {@link List<Subscription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Subscription>.Builder#build()} is called immediately and its
         * result is passed to {@link #subscriptions(List<Subscription>)}.
         * 
         * @param subscriptions
         *        a consumer that will call methods on {@link List<Subscription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscriptions(List<Subscription>)
         */
        Builder subscriptions(Consumer<Subscription.Builder>... subscriptions);
    }

    static final class BuilderImpl implements Builder {
        private List<Subscription> subscriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubscriptionDefinitionVersion model) {
            subscriptions(model.subscriptions);
        }

        public final Collection<Subscription.Builder> getSubscriptions() {
            return subscriptions != null ? subscriptions.stream().map(Subscription::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = ___listOfSubscriptionCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Subscription... subscriptions) {
            subscriptions(Arrays.asList(subscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Consumer<Subscription.Builder>... subscriptions) {
            subscriptions(Stream.of(subscriptions).map(c -> Subscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSubscriptions(Collection<Subscription.BuilderImpl> subscriptions) {
            this.subscriptions = ___listOfSubscriptionCopier.copyFromBuilder(subscriptions);
        }

        @Override
        public SubscriptionDefinitionVersion build() {
            return new SubscriptionDefinitionVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
