/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Attributes that define an Amazon S3 machine learning resource.
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3MachineLearningModelResourceData implements SdkPojo, Serializable,
        ToCopyableBuilder<S3MachineLearningModelResourceData.Builder, S3MachineLearningModelResourceData> {
    private static final SdkField<String> DESTINATION_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3MachineLearningModelResourceData::destinationPath)).setter(setter(Builder::destinationPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPath").build()).build();

    private static final SdkField<ResourceDownloadOwnerSetting> OWNER_SETTING_FIELD = SdkField
            .<ResourceDownloadOwnerSetting> builder(MarshallingType.SDK_POJO)
            .getter(getter(S3MachineLearningModelResourceData::ownerSetting)).setter(setter(Builder::ownerSetting))
            .constructor(ResourceDownloadOwnerSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerSetting").build()).build();

    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3MachineLearningModelResourceData::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_PATH_FIELD,
            OWNER_SETTING_FIELD, S3_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationPath;

    private final ResourceDownloadOwnerSetting ownerSetting;

    private final String s3Uri;

    private S3MachineLearningModelResourceData(BuilderImpl builder) {
        this.destinationPath = builder.destinationPath;
        this.ownerSetting = builder.ownerSetting;
        this.s3Uri = builder.s3Uri;
    }

    /**
     * The absolute local path of the resource inside the Lambda environment.
     * 
     * @return The absolute local path of the resource inside the Lambda environment.
     */
    public String destinationPath() {
        return destinationPath;
    }

    /**
     * Returns the value of the OwnerSetting property for this object.
     * 
     * @return The value of the OwnerSetting property for this object.
     */
    public ResourceDownloadOwnerSetting ownerSetting() {
        return ownerSetting;
    }

    /**
     * The URI of the source model in an S3 bucket. The model package must be in tar.gz or .zip format.
     * 
     * @return The URI of the source model in an S3 bucket. The model package must be in tar.gz or .zip format.
     */
    public String s3Uri() {
        return s3Uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationPath());
        hashCode = 31 * hashCode + Objects.hashCode(ownerSetting());
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3MachineLearningModelResourceData)) {
            return false;
        }
        S3MachineLearningModelResourceData other = (S3MachineLearningModelResourceData) obj;
        return Objects.equals(destinationPath(), other.destinationPath()) && Objects.equals(ownerSetting(), other.ownerSetting())
                && Objects.equals(s3Uri(), other.s3Uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("S3MachineLearningModelResourceData").add("DestinationPath", destinationPath())
                .add("OwnerSetting", ownerSetting()).add("S3Uri", s3Uri()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationPath":
            return Optional.ofNullable(clazz.cast(destinationPath()));
        case "OwnerSetting":
            return Optional.ofNullable(clazz.cast(ownerSetting()));
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3MachineLearningModelResourceData, T> g) {
        return obj -> g.apply((S3MachineLearningModelResourceData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3MachineLearningModelResourceData> {
        /**
         * The absolute local path of the resource inside the Lambda environment.
         * 
         * @param destinationPath
         *        The absolute local path of the resource inside the Lambda environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPath(String destinationPath);

        /**
         * Sets the value of the OwnerSetting property for this object.
         *
         * @param ownerSetting
         *        The new value for the OwnerSetting property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerSetting(ResourceDownloadOwnerSetting ownerSetting);

        /**
         * Sets the value of the OwnerSetting property for this object.
         *
         * This is a convenience that creates an instance of the {@link ResourceDownloadOwnerSetting.Builder} avoiding
         * the need to create one manually via {@link ResourceDownloadOwnerSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceDownloadOwnerSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #ownerSetting(ResourceDownloadOwnerSetting)}.
         * 
         * @param ownerSetting
         *        a consumer that will call methods on {@link ResourceDownloadOwnerSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ownerSetting(ResourceDownloadOwnerSetting)
         */
        default Builder ownerSetting(Consumer<ResourceDownloadOwnerSetting.Builder> ownerSetting) {
            return ownerSetting(ResourceDownloadOwnerSetting.builder().applyMutation(ownerSetting).build());
        }

        /**
         * The URI of the source model in an S3 bucket. The model package must be in tar.gz or .zip format.
         * 
         * @param s3Uri
         *        The URI of the source model in an S3 bucket. The model package must be in tar.gz or .zip format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);
    }

    static final class BuilderImpl implements Builder {
        private String destinationPath;

        private ResourceDownloadOwnerSetting ownerSetting;

        private String s3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(S3MachineLearningModelResourceData model) {
            destinationPath(model.destinationPath);
            ownerSetting(model.ownerSetting);
            s3Uri(model.s3Uri);
        }

        public final String getDestinationPath() {
            return destinationPath;
        }

        @Override
        public final Builder destinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
            return this;
        }

        public final void setDestinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
        }

        public final ResourceDownloadOwnerSetting.Builder getOwnerSetting() {
            return ownerSetting != null ? ownerSetting.toBuilder() : null;
        }

        @Override
        public final Builder ownerSetting(ResourceDownloadOwnerSetting ownerSetting) {
            this.ownerSetting = ownerSetting;
            return this;
        }

        public final void setOwnerSetting(ResourceDownloadOwnerSetting.BuilderImpl ownerSetting) {
            this.ownerSetting = ownerSetting != null ? ownerSetting.build() : null;
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public S3MachineLearningModelResourceData build() {
            return new S3MachineLearningModelResourceData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
