/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceRoleForAccountResponse extends GreengrassResponse implements
        ToCopyableBuilder<GetServiceRoleForAccountResponse.Builder, GetServiceRoleForAccountResponse> {
    private static final SdkField<String> ASSOCIATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetServiceRoleForAccountResponse::associatedAt)).setter(setter(Builder::associatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedAt").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetServiceRoleForAccountResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_AT_FIELD,
            ROLE_ARN_FIELD));

    private final String associatedAt;

    private final String roleArn;

    private GetServiceRoleForAccountResponse(BuilderImpl builder) {
        super(builder);
        this.associatedAt = builder.associatedAt;
        this.roleArn = builder.roleArn;
    }

    /**
     * The time when the service role was associated with the account.
     * 
     * @return The time when the service role was associated with the account.
     */
    public String associatedAt() {
        return associatedAt;
    }

    /**
     * The ARN of the role which is associated with the account.
     * 
     * @return The ARN of the role which is associated with the account.
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(associatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceRoleForAccountResponse)) {
            return false;
        }
        GetServiceRoleForAccountResponse other = (GetServiceRoleForAccountResponse) obj;
        return Objects.equals(associatedAt(), other.associatedAt()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetServiceRoleForAccountResponse").add("AssociatedAt", associatedAt()).add("RoleArn", roleArn())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociatedAt":
            return Optional.ofNullable(clazz.cast(associatedAt()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceRoleForAccountResponse, T> g) {
        return obj -> g.apply((GetServiceRoleForAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetServiceRoleForAccountResponse> {
        /**
         * The time when the service role was associated with the account.
         * 
         * @param associatedAt
         *        The time when the service role was associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedAt(String associatedAt);

        /**
         * The ARN of the role which is associated with the account.
         * 
         * @param roleArn
         *        The ARN of the role which is associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private String associatedAt;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceRoleForAccountResponse model) {
            super(model);
            associatedAt(model.associatedAt);
            roleArn(model.roleArn);
        }

        public final String getAssociatedAt() {
            return associatedAt;
        }

        @Override
        public final Builder associatedAt(String associatedAt) {
            this.associatedAt = associatedAt;
            return this;
        }

        public final void setAssociatedAt(String associatedAt) {
            this.associatedAt = associatedAt;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public GetServiceRoleForAccountResponse build() {
            return new GetServiceRoleForAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
