/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeviceDefinitionVersionRequest extends GreengrassRequest implements
        ToCopyableBuilder<GetDeviceDefinitionVersionRequest.Builder, GetDeviceDefinitionVersionRequest> {
    private static final SdkField<String> DEVICE_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDeviceDefinitionVersionRequest::deviceDefinitionId)).setter(setter(Builder::deviceDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DeviceDefinitionId").build()).build();

    private static final SdkField<String> DEVICE_DEFINITION_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDeviceDefinitionVersionRequest::deviceDefinitionVersionId))
            .setter(setter(Builder::deviceDefinitionVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DeviceDefinitionVersionId").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDeviceDefinitionVersionRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_DEFINITION_ID_FIELD,
            DEVICE_DEFINITION_VERSION_ID_FIELD, NEXT_TOKEN_FIELD));

    private final String deviceDefinitionId;

    private final String deviceDefinitionVersionId;

    private final String nextToken;

    private GetDeviceDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.deviceDefinitionId = builder.deviceDefinitionId;
        this.deviceDefinitionVersionId = builder.deviceDefinitionVersionId;
        this.nextToken = builder.nextToken;
    }

    /**
     * The ID of the device definition.
     * 
     * @return The ID of the device definition.
     */
    public String deviceDefinitionId() {
        return deviceDefinitionId;
    }

    /**
     * The ID of the device definition version. This value maps to the ''Version'' property of the corresponding
     * ''VersionInformation'' object, which is returned by ''ListDeviceDefinitionVersions'' requests. If the version is
     * the last one that was associated with a device definition, the value also maps to the ''LatestVersion'' property
     * of the corresponding ''DefinitionInformation'' object.
     * 
     * @return The ID of the device definition version. This value maps to the ''Version'' property of the corresponding
     *         ''VersionInformation'' object, which is returned by ''ListDeviceDefinitionVersions'' requests. If the
     *         version is the last one that was associated with a device definition, the value also maps to the
     *         ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
     */
    public String deviceDefinitionVersionId() {
        return deviceDefinitionVersionId;
    }

    /**
     * The token for the next set of results, or ''null'' if there are no additional results.
     * 
     * @return The token for the next set of results, or ''null'' if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceDefinitionVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceDefinitionVersionRequest)) {
            return false;
        }
        GetDeviceDefinitionVersionRequest other = (GetDeviceDefinitionVersionRequest) obj;
        return Objects.equals(deviceDefinitionId(), other.deviceDefinitionId())
                && Objects.equals(deviceDefinitionVersionId(), other.deviceDefinitionVersionId())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDeviceDefinitionVersionRequest").add("DeviceDefinitionId", deviceDefinitionId())
                .add("DeviceDefinitionVersionId", deviceDefinitionVersionId()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceDefinitionId":
            return Optional.ofNullable(clazz.cast(deviceDefinitionId()));
        case "DeviceDefinitionVersionId":
            return Optional.ofNullable(clazz.cast(deviceDefinitionVersionId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeviceDefinitionVersionRequest, T> g) {
        return obj -> g.apply((GetDeviceDefinitionVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDeviceDefinitionVersionRequest> {
        /**
         * The ID of the device definition.
         * 
         * @param deviceDefinitionId
         *        The ID of the device definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceDefinitionId(String deviceDefinitionId);

        /**
         * The ID of the device definition version. This value maps to the ''Version'' property of the corresponding
         * ''VersionInformation'' object, which is returned by ''ListDeviceDefinitionVersions'' requests. If the version
         * is the last one that was associated with a device definition, the value also maps to the ''LatestVersion''
         * property of the corresponding ''DefinitionInformation'' object.
         * 
         * @param deviceDefinitionVersionId
         *        The ID of the device definition version. This value maps to the ''Version'' property of the
         *        corresponding ''VersionInformation'' object, which is returned by ''ListDeviceDefinitionVersions''
         *        requests. If the version is the last one that was associated with a device definition, the value also
         *        maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceDefinitionVersionId(String deviceDefinitionVersionId);

        /**
         * The token for the next set of results, or ''null'' if there are no additional results.
         * 
         * @param nextToken
         *        The token for the next set of results, or ''null'' if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String deviceDefinitionId;

        private String deviceDefinitionVersionId;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceDefinitionVersionRequest model) {
            super(model);
            deviceDefinitionId(model.deviceDefinitionId);
            deviceDefinitionVersionId(model.deviceDefinitionVersionId);
            nextToken(model.nextToken);
        }

        public final String getDeviceDefinitionId() {
            return deviceDefinitionId;
        }

        @Override
        public final Builder deviceDefinitionId(String deviceDefinitionId) {
            this.deviceDefinitionId = deviceDefinitionId;
            return this;
        }

        public final void setDeviceDefinitionId(String deviceDefinitionId) {
            this.deviceDefinitionId = deviceDefinitionId;
        }

        public final String getDeviceDefinitionVersionId() {
            return deviceDefinitionVersionId;
        }

        @Override
        public final Builder deviceDefinitionVersionId(String deviceDefinitionVersionId) {
            this.deviceDefinitionVersionId = deviceDefinitionVersionId;
            return this;
        }

        public final void setDeviceDefinitionVersionId(String deviceDefinitionVersionId) {
            this.deviceDefinitionVersionId = deviceDefinitionVersionId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDeviceDefinitionVersionRequest build() {
            return new GetDeviceDefinitionVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
