/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The environment configuration of the function.
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionConfigurationEnvironment implements SdkPojo, Serializable,
        ToCopyableBuilder<FunctionConfigurationEnvironment.Builder, FunctionConfigurationEnvironment> {
    private static final SdkField<Boolean> ACCESS_SYSFS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(FunctionConfigurationEnvironment::accessSysfs)).setter(setter(Builder::accessSysfs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessSysfs").build()).build();

    private static final SdkField<FunctionExecutionConfig> EXECUTION_FIELD = SdkField
            .<FunctionExecutionConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(FunctionConfigurationEnvironment::execution)).setter(setter(Builder::execution))
            .constructor(FunctionExecutionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Execution").build()).build();

    private static final SdkField<List<ResourceAccessPolicy>> RESOURCE_ACCESS_POLICIES_FIELD = SdkField
            .<List<ResourceAccessPolicy>> builder(MarshallingType.LIST)
            .getter(getter(FunctionConfigurationEnvironment::resourceAccessPolicies))
            .setter(setter(Builder::resourceAccessPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAccessPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceAccessPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceAccessPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(FunctionConfigurationEnvironment::variables))
            .setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Variables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_SYSFS_FIELD,
            EXECUTION_FIELD, RESOURCE_ACCESS_POLICIES_FIELD, VARIABLES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean accessSysfs;

    private final FunctionExecutionConfig execution;

    private final List<ResourceAccessPolicy> resourceAccessPolicies;

    private final Map<String, String> variables;

    private FunctionConfigurationEnvironment(BuilderImpl builder) {
        this.accessSysfs = builder.accessSysfs;
        this.execution = builder.execution;
        this.resourceAccessPolicies = builder.resourceAccessPolicies;
        this.variables = builder.variables;
    }

    /**
     * If true, the Lambda function is allowed to access the host's /sys folder. Use this when the Lambda function needs
     * to read device information from /sys. This setting applies only when you run the Lambda function in a Greengrass
     * container.
     * 
     * @return If true, the Lambda function is allowed to access the host's /sys folder. Use this when the Lambda
     *         function needs to read device information from /sys. This setting applies only when you run the Lambda
     *         function in a Greengrass container.
     */
    public Boolean accessSysfs() {
        return accessSysfs;
    }

    /**
     * Configuration related to executing the Lambda function
     * 
     * @return Configuration related to executing the Lambda function
     */
    public FunctionExecutionConfig execution() {
        return execution;
    }

    /**
     * Returns true if the ResourceAccessPolicies property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResourceAccessPolicies() {
        return resourceAccessPolicies != null && !(resourceAccessPolicies instanceof SdkAutoConstructList);
    }

    /**
     * A list of the resources, with their permissions, to which the Lambda function will be granted access. A Lambda
     * function can have at most 10 resources. ResourceAccessPolicies apply only when you run the Lambda function in a
     * Greengrass container.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceAccessPolicies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the resources, with their permissions, to which the Lambda function will be granted access. A
     *         Lambda function can have at most 10 resources. ResourceAccessPolicies apply only when you run the Lambda
     *         function in a Greengrass container.
     */
    public List<ResourceAccessPolicy> resourceAccessPolicies() {
        return resourceAccessPolicies;
    }

    /**
     * Returns true if the Variables property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVariables() {
        return variables != null && !(variables instanceof SdkAutoConstructMap);
    }

    /**
     * Environment variables for the Lambda function's configuration.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVariables()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Environment variables for the Lambda function's configuration.
     */
    public Map<String, String> variables() {
        return variables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessSysfs());
        hashCode = 31 * hashCode + Objects.hashCode(execution());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAccessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(variables());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionConfigurationEnvironment)) {
            return false;
        }
        FunctionConfigurationEnvironment other = (FunctionConfigurationEnvironment) obj;
        return Objects.equals(accessSysfs(), other.accessSysfs()) && Objects.equals(execution(), other.execution())
                && Objects.equals(resourceAccessPolicies(), other.resourceAccessPolicies())
                && Objects.equals(variables(), other.variables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FunctionConfigurationEnvironment").add("AccessSysfs", accessSysfs())
                .add("Execution", execution()).add("ResourceAccessPolicies", resourceAccessPolicies())
                .add("Variables", variables()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessSysfs":
            return Optional.ofNullable(clazz.cast(accessSysfs()));
        case "Execution":
            return Optional.ofNullable(clazz.cast(execution()));
        case "ResourceAccessPolicies":
            return Optional.ofNullable(clazz.cast(resourceAccessPolicies()));
        case "Variables":
            return Optional.ofNullable(clazz.cast(variables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionConfigurationEnvironment, T> g) {
        return obj -> g.apply((FunctionConfigurationEnvironment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionConfigurationEnvironment> {
        /**
         * If true, the Lambda function is allowed to access the host's /sys folder. Use this when the Lambda function
         * needs to read device information from /sys. This setting applies only when you run the Lambda function in a
         * Greengrass container.
         * 
         * @param accessSysfs
         *        If true, the Lambda function is allowed to access the host's /sys folder. Use this when the Lambda
         *        function needs to read device information from /sys. This setting applies only when you run the Lambda
         *        function in a Greengrass container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessSysfs(Boolean accessSysfs);

        /**
         * Configuration related to executing the Lambda function
         * 
         * @param execution
         *        Configuration related to executing the Lambda function
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder execution(FunctionExecutionConfig execution);

        /**
         * Configuration related to executing the Lambda function This is a convenience that creates an instance of the
         * {@link FunctionExecutionConfig.Builder} avoiding the need to create one manually via
         * {@link FunctionExecutionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link FunctionExecutionConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #execution(FunctionExecutionConfig)}.
         * 
         * @param execution
         *        a consumer that will call methods on {@link FunctionExecutionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #execution(FunctionExecutionConfig)
         */
        default Builder execution(Consumer<FunctionExecutionConfig.Builder> execution) {
            return execution(FunctionExecutionConfig.builder().applyMutation(execution).build());
        }

        /**
         * A list of the resources, with their permissions, to which the Lambda function will be granted access. A
         * Lambda function can have at most 10 resources. ResourceAccessPolicies apply only when you run the Lambda
         * function in a Greengrass container.
         * 
         * @param resourceAccessPolicies
         *        A list of the resources, with their permissions, to which the Lambda function will be granted access.
         *        A Lambda function can have at most 10 resources. ResourceAccessPolicies apply only when you run the
         *        Lambda function in a Greengrass container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAccessPolicies(Collection<ResourceAccessPolicy> resourceAccessPolicies);

        /**
         * A list of the resources, with their permissions, to which the Lambda function will be granted access. A
         * Lambda function can have at most 10 resources. ResourceAccessPolicies apply only when you run the Lambda
         * function in a Greengrass container.
         * 
         * @param resourceAccessPolicies
         *        A list of the resources, with their permissions, to which the Lambda function will be granted access.
         *        A Lambda function can have at most 10 resources. ResourceAccessPolicies apply only when you run the
         *        Lambda function in a Greengrass container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAccessPolicies(ResourceAccessPolicy... resourceAccessPolicies);

        /**
         * A list of the resources, with their permissions, to which the Lambda function will be granted access. A
         * Lambda function can have at most 10 resources. ResourceAccessPolicies apply only when you run the Lambda
         * function in a Greengrass container. This is a convenience that creates an instance of the {@link List
         * <ResourceAccessPolicy>.Builder} avoiding the need to create one manually via {@link List
         * <ResourceAccessPolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceAccessPolicy>.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceAccessPolicies(List<ResourceAccessPolicy>)}.
         * 
         * @param resourceAccessPolicies
         *        a consumer that will call methods on {@link List<ResourceAccessPolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAccessPolicies(List<ResourceAccessPolicy>)
         */
        Builder resourceAccessPolicies(Consumer<ResourceAccessPolicy.Builder>... resourceAccessPolicies);

        /**
         * Environment variables for the Lambda function's configuration.
         * 
         * @param variables
         *        Environment variables for the Lambda function's configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Map<String, String> variables);
    }

    static final class BuilderImpl implements Builder {
        private Boolean accessSysfs;

        private FunctionExecutionConfig execution;

        private List<ResourceAccessPolicy> resourceAccessPolicies = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> variables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionConfigurationEnvironment model) {
            accessSysfs(model.accessSysfs);
            execution(model.execution);
            resourceAccessPolicies(model.resourceAccessPolicies);
            variables(model.variables);
        }

        public final Boolean getAccessSysfs() {
            return accessSysfs;
        }

        @Override
        public final Builder accessSysfs(Boolean accessSysfs) {
            this.accessSysfs = accessSysfs;
            return this;
        }

        public final void setAccessSysfs(Boolean accessSysfs) {
            this.accessSysfs = accessSysfs;
        }

        public final FunctionExecutionConfig.Builder getExecution() {
            return execution != null ? execution.toBuilder() : null;
        }

        @Override
        public final Builder execution(FunctionExecutionConfig execution) {
            this.execution = execution;
            return this;
        }

        public final void setExecution(FunctionExecutionConfig.BuilderImpl execution) {
            this.execution = execution != null ? execution.build() : null;
        }

        public final Collection<ResourceAccessPolicy.Builder> getResourceAccessPolicies() {
            return resourceAccessPolicies != null ? resourceAccessPolicies.stream().map(ResourceAccessPolicy::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAccessPolicies(Collection<ResourceAccessPolicy> resourceAccessPolicies) {
            this.resourceAccessPolicies = ___listOfResourceAccessPolicyCopier.copy(resourceAccessPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAccessPolicies(ResourceAccessPolicy... resourceAccessPolicies) {
            resourceAccessPolicies(Arrays.asList(resourceAccessPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAccessPolicies(Consumer<ResourceAccessPolicy.Builder>... resourceAccessPolicies) {
            resourceAccessPolicies(Stream.of(resourceAccessPolicies)
                    .map(c -> ResourceAccessPolicy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAccessPolicies(Collection<ResourceAccessPolicy.BuilderImpl> resourceAccessPolicies) {
            this.resourceAccessPolicies = ___listOfResourceAccessPolicyCopier.copyFromBuilder(resourceAccessPolicies);
        }

        public final Map<String, String> getVariables() {
            return variables;
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = ___mapOf__stringCopier.copy(variables);
            return this;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = ___mapOf__stringCopier.copy(variables);
        }

        @Override
        public FunctionConfigurationEnvironment build() {
            return new FunctionConfigurationEnvironment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
