/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about a deployment.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Deployment implements SdkPojo, Serializable, ToCopyableBuilder<Deployment.Builder, Deployment> {
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Deployment::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> DEPLOYMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Deployment::deploymentArn)).setter(setter(Builder::deploymentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentArn").build()).build();

    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Deployment::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()).build();

    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Deployment::deploymentTypeAsString)).setter(setter(Builder::deploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()).build();

    private static final SdkField<String> GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Deployment::groupArn)).setter(setter(Builder::groupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            DEPLOYMENT_ARN_FIELD, DEPLOYMENT_ID_FIELD, DEPLOYMENT_TYPE_FIELD, GROUP_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String createdAt;

    private final String deploymentArn;

    private final String deploymentId;

    private final String deploymentType;

    private final String groupArn;

    private Deployment(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.deploymentArn = builder.deploymentArn;
        this.deploymentId = builder.deploymentId;
        this.deploymentType = builder.deploymentType;
        this.groupArn = builder.groupArn;
    }

    /**
     * The time, in milliseconds since the epoch, when the deployment was created.
     * 
     * @return The time, in milliseconds since the epoch, when the deployment was created.
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * The ARN of the deployment.
     * 
     * @return The ARN of the deployment.
     */
    public String deploymentArn() {
        return deploymentArn;
    }

    /**
     * The ID of the deployment.
     * 
     * @return The ID of the deployment.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * The type of the deployment.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return The type of the deployment.
     * @see DeploymentType
     */
    public DeploymentType deploymentType() {
        return DeploymentType.fromValue(deploymentType);
    }

    /**
     * The type of the deployment.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentType}
     * will return {@link DeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentTypeAsString}.
     * </p>
     * 
     * @return The type of the deployment.
     * @see DeploymentType
     */
    public String deploymentTypeAsString() {
        return deploymentType;
    }

    /**
     * The ARN of the group for this deployment.
     * 
     * @return The ARN of the group for this deployment.
     */
    public String groupArn() {
        return groupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentArn());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(groupArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(deploymentArn(), other.deploymentArn())
                && Objects.equals(deploymentId(), other.deploymentId())
                && Objects.equals(deploymentTypeAsString(), other.deploymentTypeAsString())
                && Objects.equals(groupArn(), other.groupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Deployment").add("CreatedAt", createdAt()).add("DeploymentArn", deploymentArn())
                .add("DeploymentId", deploymentId()).add("DeploymentType", deploymentTypeAsString()).add("GroupArn", groupArn())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "DeploymentArn":
            return Optional.ofNullable(clazz.cast(deploymentArn()));
        case "DeploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "DeploymentType":
            return Optional.ofNullable(clazz.cast(deploymentTypeAsString()));
        case "GroupArn":
            return Optional.ofNullable(clazz.cast(groupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Deployment, T> g) {
        return obj -> g.apply((Deployment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Deployment> {
        /**
         * The time, in milliseconds since the epoch, when the deployment was created.
         * 
         * @param createdAt
         *        The time, in milliseconds since the epoch, when the deployment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * The ARN of the deployment.
         * 
         * @param deploymentArn
         *        The ARN of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentArn(String deploymentArn);

        /**
         * The ID of the deployment.
         * 
         * @param deploymentId
         *        The ID of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * The type of the deployment.
         * 
         * @param deploymentType
         *        The type of the deployment.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(String deploymentType);

        /**
         * The type of the deployment.
         * 
         * @param deploymentType
         *        The type of the deployment.
         * @see DeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentType
         */
        Builder deploymentType(DeploymentType deploymentType);

        /**
         * The ARN of the group for this deployment.
         * 
         * @param groupArn
         *        The ARN of the group for this deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupArn(String groupArn);
    }

    static final class BuilderImpl implements Builder {
        private String createdAt;

        private String deploymentArn;

        private String deploymentId;

        private String deploymentType;

        private String groupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Deployment model) {
            createdAt(model.createdAt);
            deploymentArn(model.deploymentArn);
            deploymentId(model.deploymentId);
            deploymentType(model.deploymentType);
            groupArn(model.groupArn);
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDeploymentArn() {
            return deploymentArn;
        }

        @Override
        public final Builder deploymentArn(String deploymentArn) {
            this.deploymentArn = deploymentArn;
            return this;
        }

        public final void setDeploymentArn(String deploymentArn) {
            this.deploymentArn = deploymentArn;
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getDeploymentType() {
            return deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        public final String getGroupArn() {
            return groupArn;
        }

        @Override
        public final Builder groupArn(String groupArn) {
            this.groupArn = groupArn;
            return this;
        }

        public final void setGroupArn(String groupArn) {
            this.groupArn = groupArn;
        }

        @Override
        public Deployment build() {
            return new Deployment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
