/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSubscriptionDefinitionResponse extends GreengrassResponse implements
        ToCopyableBuilder<CreateSubscriptionDefinitionResponse.Builder, CreateSubscriptionDefinitionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSubscriptionDefinitionResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CREATION_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSubscriptionDefinitionResponse::creationTimestamp)).setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSubscriptionDefinitionResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSubscriptionDefinitionResponse::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final SdkField<String> LATEST_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSubscriptionDefinitionResponse::latestVersion)).setter(setter(Builder::latestVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersion").build()).build();

    private static final SdkField<String> LATEST_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSubscriptionDefinitionResponse::latestVersionArn)).setter(setter(Builder::latestVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSubscriptionDefinitionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIMESTAMP_FIELD, ID_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, LATEST_VERSION_FIELD, LATEST_VERSION_ARN_FIELD,
            NAME_FIELD));

    private final String arn;

    private final String creationTimestamp;

    private final String id;

    private final String lastUpdatedTimestamp;

    private final String latestVersion;

    private final String latestVersionArn;

    private final String name;

    private CreateSubscriptionDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTimestamp = builder.creationTimestamp;
        this.id = builder.id;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.latestVersion = builder.latestVersion;
        this.latestVersionArn = builder.latestVersionArn;
        this.name = builder.name;
    }

    /**
     * The ARN of the definition.
     * 
     * @return The ARN of the definition.
     */
    public String arn() {
        return arn;
    }

    /**
     * The time, in milliseconds since the epoch, when the definition was created.
     * 
     * @return The time, in milliseconds since the epoch, when the definition was created.
     */
    public String creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * The ID of the definition.
     * 
     * @return The ID of the definition.
     */
    public String id() {
        return id;
    }

    /**
     * The time, in milliseconds since the epoch, when the definition was last updated.
     * 
     * @return The time, in milliseconds since the epoch, when the definition was last updated.
     */
    public String lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    /**
     * The ID of the latest version associated with the definition.
     * 
     * @return The ID of the latest version associated with the definition.
     */
    public String latestVersion() {
        return latestVersion;
    }

    /**
     * The ARN of the latest version associated with the definition.
     * 
     * @return The ARN of the latest version associated with the definition.
     */
    public String latestVersionArn() {
        return latestVersionArn;
    }

    /**
     * The name of the definition.
     * 
     * @return The name of the definition.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriptionDefinitionResponse)) {
            return false;
        }
        CreateSubscriptionDefinitionResponse other = (CreateSubscriptionDefinitionResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(id(), other.id()) && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp())
                && Objects.equals(latestVersion(), other.latestVersion())
                && Objects.equals(latestVersionArn(), other.latestVersionArn()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateSubscriptionDefinitionResponse").add("Arn", arn())
                .add("CreationTimestamp", creationTimestamp()).add("Id", id())
                .add("LastUpdatedTimestamp", lastUpdatedTimestamp()).add("LatestVersion", latestVersion())
                .add("LatestVersionArn", latestVersionArn()).add("Name", name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        case "LatestVersion":
            return Optional.ofNullable(clazz.cast(latestVersion()));
        case "LatestVersionArn":
            return Optional.ofNullable(clazz.cast(latestVersionArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriptionDefinitionResponse, T> g) {
        return obj -> g.apply((CreateSubscriptionDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSubscriptionDefinitionResponse> {
        /**
         * The ARN of the definition.
         * 
         * @param arn
         *        The ARN of the definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * The time, in milliseconds since the epoch, when the definition was created.
         * 
         * @param creationTimestamp
         *        The time, in milliseconds since the epoch, when the definition was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(String creationTimestamp);

        /**
         * The ID of the definition.
         * 
         * @param id
         *        The ID of the definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The time, in milliseconds since the epoch, when the definition was last updated.
         * 
         * @param lastUpdatedTimestamp
         *        The time, in milliseconds since the epoch, when the definition was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(String lastUpdatedTimestamp);

        /**
         * The ID of the latest version associated with the definition.
         * 
         * @param latestVersion
         *        The ID of the latest version associated with the definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersion(String latestVersion);

        /**
         * The ARN of the latest version associated with the definition.
         * 
         * @param latestVersionArn
         *        The ARN of the latest version associated with the definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionArn(String latestVersionArn);

        /**
         * The name of the definition.
         * 
         * @param name
         *        The name of the definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl extends GreengrassResponse.BuilderImpl implements Builder {
        private String arn;

        private String creationTimestamp;

        private String id;

        private String lastUpdatedTimestamp;

        private String latestVersion;

        private String latestVersionArn;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriptionDefinitionResponse model) {
            super(model);
            arn(model.arn);
            creationTimestamp(model.creationTimestamp);
            id(model.id);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            latestVersion(model.latestVersion);
            latestVersionArn(model.latestVersionArn);
            name(model.name);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCreationTimestamp() {
            return creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(String lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final void setLastUpdatedTimestamp(String lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        public final String getLatestVersion() {
            return latestVersion;
        }

        @Override
        public final Builder latestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final void setLatestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
        }

        public final String getLatestVersionArn() {
            return latestVersionArn;
        }

        @Override
        public final Builder latestVersionArn(String latestVersionArn) {
            this.latestVersionArn = latestVersionArn;
            return this;
        }

        public final void setLatestVersionArn(String latestVersionArn) {
            this.latestVersionArn = latestVersionArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public CreateSubscriptionDefinitionResponse build() {
            return new CreateSubscriptionDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
