/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.Logger;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LoggerMarshaller {
    private static final MarshallingInfo<String> COMPONENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Component").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> LEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Level").isBinary(false).build();
    private static final MarshallingInfo<Integer> SPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Space").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final LoggerMarshaller INSTANCE = new LoggerMarshaller();

    private LoggerMarshaller() {
    }

    public static LoggerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Logger logger, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)logger, (String)"logger");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)logger.componentString(), COMPONENT_BINDING);
            protocolMarshaller.marshall((Object)logger.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)logger.levelString(), LEVEL_BINDING);
            protocolMarshaller.marshall((Object)logger.space(), SPACE_BINDING);
            protocolMarshaller.marshall((Object)logger.typeString(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

