/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionVersionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateLoggerDefinitionVersionRequestModelMarshaller {
    private static final MarshallingInfo<String> AMZNCLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("X-Amzn-Client-Token").isBinary(false).build();
    private static final MarshallingInfo<String> LOGGERDEFINITIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("LoggerDefinitionId").isBinary(false).build();
    private static final MarshallingInfo<List> LOGGERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Loggers").isBinary(false).build();
    private static final CreateLoggerDefinitionVersionRequestModelMarshaller INSTANCE = new CreateLoggerDefinitionVersionRequestModelMarshaller();

    private CreateLoggerDefinitionVersionRequestModelMarshaller() {
    }

    public static CreateLoggerDefinitionVersionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateLoggerDefinitionVersionRequest createLoggerDefinitionVersionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createLoggerDefinitionVersionRequest), (String)"createLoggerDefinitionVersionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createLoggerDefinitionVersionRequest.amznClientToken(), AMZNCLIENTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createLoggerDefinitionVersionRequest.loggerDefinitionId(), LOGGERDEFINITIONID_BINDING);
            protocolMarshaller.marshall(createLoggerDefinitionVersionRequest.loggers(), LOGGERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

