/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionVersionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateFunctionDefinitionVersionRequestModelMarshaller {
    private static final MarshallingInfo<String> AMZNCLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("X-Amzn-Client-Token").isBinary(false).build();
    private static final MarshallingInfo<String> FUNCTIONDEFINITIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("FunctionDefinitionId").isBinary(false).build();
    private static final MarshallingInfo<List> FUNCTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Functions").isBinary(false).build();
    private static final CreateFunctionDefinitionVersionRequestModelMarshaller INSTANCE = new CreateFunctionDefinitionVersionRequestModelMarshaller();

    private CreateFunctionDefinitionVersionRequestModelMarshaller() {
    }

    public static CreateFunctionDefinitionVersionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateFunctionDefinitionVersionRequest createFunctionDefinitionVersionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createFunctionDefinitionVersionRequest), (String)"createFunctionDefinitionVersionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createFunctionDefinitionVersionRequest.amznClientToken(), AMZNCLIENTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createFunctionDefinitionVersionRequest.functionDefinitionId(), FUNCTIONDEFINITIONID_BINDING);
            protocolMarshaller.marshall(createFunctionDefinitionVersionRequest.functions(), FUNCTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

