/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.CoreDefinitionVersion;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CoreDefinitionVersionMarshaller {
    private static final MarshallingInfo<List> CORES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Cores").isBinary(false).build();
    private static final CoreDefinitionVersionMarshaller INSTANCE = new CoreDefinitionVersionMarshaller();

    private CoreDefinitionVersionMarshaller() {
    }

    public static CoreDefinitionVersionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CoreDefinitionVersion coreDefinitionVersion, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)coreDefinitionVersion, (String)"coreDefinitionVersion");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(coreDefinitionVersion.cores(), CORES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

