/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.ConnectivityInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConnectivityInfoMarshaller {
    private static final MarshallingInfo<String> HOSTADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HostAddress").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> METADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Metadata").isBinary(false).build();
    private static final MarshallingInfo<Integer> PORTNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PortNumber").isBinary(false).build();
    private static final ConnectivityInfoMarshaller INSTANCE = new ConnectivityInfoMarshaller();

    private ConnectivityInfoMarshaller() {
    }

    public static ConnectivityInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConnectivityInfo connectivityInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)connectivityInfo, (String)"connectivityInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)connectivityInfo.hostAddress(), HOSTADDRESS_BINDING);
            protocolMarshaller.marshall((Object)connectivityInfo.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)connectivityInfo.metadata(), METADATA_BINDING);
            protocolMarshaller.marshall((Object)connectivityInfo.portNumber(), PORTNUMBER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

