/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.Function;
import software.amazon.awssdk.services.greengrass.model.ListOfFunctionCopier;
import software.amazon.awssdk.services.greengrass.transform.FunctionDefinitionVersionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FunctionDefinitionVersion
implements StructuredPojo,
ToCopyableBuilder<Builder, FunctionDefinitionVersion> {
    private final List<Function> functions;

    private FunctionDefinitionVersion(BuilderImpl builder) {
        this.functions = builder.functions;
    }

    public List<Function> functions() {
        return this.functions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionDefinitionVersion)) {
            return false;
        }
        FunctionDefinitionVersion other = (FunctionDefinitionVersion)obj;
        return Objects.equals(this.functions(), other.functions());
    }

    public String toString() {
        return ToString.builder((String)"FunctionDefinitionVersion").add("Functions", this.functions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Functions": {
                return Optional.of(clazz.cast(this.functions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FunctionDefinitionVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Function> functions;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionDefinitionVersion model) {
            this.functions(model.functions);
        }

        public final Collection<Function.Builder> getFunctions() {
            return this.functions != null ? (Collection)this.functions.stream().map(Function::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder functions(Collection<Function> functions) {
            this.functions = ListOfFunctionCopier.copy(functions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(Function ... functions) {
            this.functions(Arrays.asList(functions));
            return this;
        }

        public final void setFunctions(Collection<Function.BuilderImpl> functions) {
            this.functions = ListOfFunctionCopier.copyFromBuilder(functions);
        }

        public FunctionDefinitionVersion build() {
            return new FunctionDefinitionVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FunctionDefinitionVersion> {
        public Builder functions(Collection<Function> var1);

        public Builder functions(Function ... var1);
    }
}

