/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListFunctionDefinitionVersionsRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, ListFunctionDefinitionVersionsRequest> {
    private final String functionDefinitionId;
    private final String maxResults;
    private final String nextToken;

    private ListFunctionDefinitionVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.functionDefinitionId = builder.functionDefinitionId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public String functionDefinitionId() {
        return this.functionDefinitionId;
    }

    public String maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionDefinitionVersionsRequest)) {
            return false;
        }
        ListFunctionDefinitionVersionsRequest other = (ListFunctionDefinitionVersionsRequest)((Object)obj);
        return Objects.equals(this.functionDefinitionId(), other.functionDefinitionId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.functionDefinitionId() != null) {
            sb.append("FunctionDefinitionId: ").append(this.functionDefinitionId()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionDefinitionId": {
                return Optional.of(clazz.cast(this.functionDefinitionId()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String functionDefinitionId;
        private String maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionDefinitionVersionsRequest model) {
            this.functionDefinitionId(model.functionDefinitionId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getFunctionDefinitionId() {
            return this.functionDefinitionId;
        }

        @Override
        public final Builder functionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
            return this;
        }

        public final void setFunctionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
        }

        public final String getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(String maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(String maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListFunctionDefinitionVersionsRequest build() {
            return new ListFunctionDefinitionVersionsRequest(this);
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    CopyableBuilder<Builder, ListFunctionDefinitionVersionsRequest> {
        public Builder functionDefinitionId(String var1);

        public Builder maxResults(String var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

