/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.greengrass.model.DefinitionInformation;
import software.amazon.awssdk.services.greengrass.model.GreengrassResponse;
import software.amazon.awssdk.services.greengrass.model.ListOfDefinitionInformationCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCoreDefinitionsResponse
extends GreengrassResponse
implements ToCopyableBuilder<Builder, ListCoreDefinitionsResponse> {
    private final List<DefinitionInformation> definitions;
    private final String nextToken;

    private ListCoreDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.definitions = builder.definitions;
        this.nextToken = builder.nextToken;
    }

    public List<DefinitionInformation> definitions() {
        return this.definitions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.definitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCoreDefinitionsResponse)) {
            return false;
        }
        ListCoreDefinitionsResponse other = (ListCoreDefinitionsResponse)((Object)obj);
        return Objects.equals(this.definitions(), other.definitions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.definitions() != null) {
            sb.append("Definitions: ").append(this.definitions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Definitions": {
                return Optional.of(clazz.cast(this.definitions()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassResponse.BuilderImpl
    implements Builder {
        private List<DefinitionInformation> definitions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCoreDefinitionsResponse model) {
            this.definitions(model.definitions);
            this.nextToken(model.nextToken);
        }

        public final Collection<DefinitionInformation.Builder> getDefinitions() {
            return this.definitions != null ? (Collection)this.definitions.stream().map(DefinitionInformation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder definitions(Collection<DefinitionInformation> definitions) {
            this.definitions = ListOfDefinitionInformationCopier.copy(definitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder definitions(DefinitionInformation ... definitions) {
            this.definitions(Arrays.asList(definitions));
            return this;
        }

        public final void setDefinitions(Collection<DefinitionInformation.BuilderImpl> definitions) {
            this.definitions = ListOfDefinitionInformationCopier.copyFromBuilder(definitions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCoreDefinitionsResponse build() {
            return new ListCoreDefinitionsResponse(this);
        }
    }

    public static interface Builder
    extends GreengrassResponse.Builder,
    CopyableBuilder<Builder, ListCoreDefinitionsResponse> {
        public Builder definitions(Collection<DefinitionInformation> var1);

        public Builder definitions(DefinitionInformation ... var1);

        public Builder nextToken(String var1);
    }
}

