/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.services.greengrass.model.GroupVersion;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateGroupRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, CreateGroupRequest> {
    private final String amznClientToken;
    private final GroupVersion initialVersion;
    private final String name;

    private CreateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.initialVersion = builder.initialVersion;
        this.name = builder.name;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public GroupVersion initialVersion() {
        return this.initialVersion;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupRequest)) {
            return false;
        }
        CreateGroupRequest other = (CreateGroupRequest)((Object)obj);
        return Objects.equals(this.amznClientToken(), other.amznClientToken()) && Objects.equals(this.initialVersion(), other.initialVersion()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.amznClientToken() != null) {
            sb.append("AmznClientToken: ").append(this.amznClientToken()).append(",");
        }
        if (this.initialVersion() != null) {
            sb.append("InitialVersion: ").append(this.initialVersion()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.of(clazz.cast(this.amznClientToken()));
            }
            case "InitialVersion": {
                return Optional.of(clazz.cast(this.initialVersion()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String amznClientToken;
        private GroupVersion initialVersion;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupRequest model) {
            this.amznClientToken(model.amznClientToken);
            this.initialVersion(model.initialVersion);
            this.name(model.name);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final GroupVersion.Builder getInitialVersion() {
            return this.initialVersion != null ? this.initialVersion.toBuilder() : null;
        }

        @Override
        public final Builder initialVersion(GroupVersion initialVersion) {
            this.initialVersion = initialVersion;
            return this;
        }

        public final void setInitialVersion(GroupVersion.BuilderImpl initialVersion) {
            this.initialVersion = initialVersion != null ? initialVersion.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateGroupRequest build() {
            return new CreateGroupRequest(this);
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    CopyableBuilder<Builder, CreateGroupRequest> {
        public Builder amznClientToken(String var1);

        public Builder initialVersion(GroupVersion var1);

        default public Builder initialVersion(Consumer<GroupVersion.Builder> initialVersion) {
            return this.initialVersion((GroupVersion)((GroupVersion.Builder)GroupVersion.builder().apply(initialVersion)).build());
        }

        public Builder name(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

