/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.greengrass.model.Function;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.services.greengrass.model.ListOfFunctionCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateFunctionDefinitionVersionRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, CreateFunctionDefinitionVersionRequest> {
    private final String amznClientToken;
    private final String functionDefinitionId;
    private final List<Function> functions;

    private CreateFunctionDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.functionDefinitionId = builder.functionDefinitionId;
        this.functions = builder.functions;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public String functionDefinitionId() {
        return this.functionDefinitionId;
    }

    public List<Function> functions() {
        return this.functions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.functions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFunctionDefinitionVersionRequest)) {
            return false;
        }
        CreateFunctionDefinitionVersionRequest other = (CreateFunctionDefinitionVersionRequest)((Object)obj);
        return Objects.equals(this.amznClientToken(), other.amznClientToken()) && Objects.equals(this.functionDefinitionId(), other.functionDefinitionId()) && Objects.equals(this.functions(), other.functions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.amznClientToken() != null) {
            sb.append("AmznClientToken: ").append(this.amznClientToken()).append(",");
        }
        if (this.functionDefinitionId() != null) {
            sb.append("FunctionDefinitionId: ").append(this.functionDefinitionId()).append(",");
        }
        if (this.functions() != null) {
            sb.append("Functions: ").append(this.functions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.of(clazz.cast(this.amznClientToken()));
            }
            case "FunctionDefinitionId": {
                return Optional.of(clazz.cast(this.functionDefinitionId()));
            }
            case "Functions": {
                return Optional.of(clazz.cast(this.functions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String amznClientToken;
        private String functionDefinitionId;
        private List<Function> functions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFunctionDefinitionVersionRequest model) {
            this.amznClientToken(model.amznClientToken);
            this.functionDefinitionId(model.functionDefinitionId);
            this.functions(model.functions);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getFunctionDefinitionId() {
            return this.functionDefinitionId;
        }

        @Override
        public final Builder functionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
            return this;
        }

        public final void setFunctionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
        }

        public final Collection<Function.Builder> getFunctions() {
            return this.functions != null ? (Collection)this.functions.stream().map(Function::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder functions(Collection<Function> functions) {
            this.functions = ListOfFunctionCopier.copy(functions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(Function ... functions) {
            this.functions(Arrays.asList(functions));
            return this;
        }

        public final void setFunctions(Collection<Function.BuilderImpl> functions) {
            this.functions = ListOfFunctionCopier.copyFromBuilder(functions);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateFunctionDefinitionVersionRequest build() {
            return new CreateFunctionDefinitionVersionRequest(this);
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    CopyableBuilder<Builder, CreateFunctionDefinitionVersionRequest> {
        public Builder amznClientToken(String var1);

        public Builder functionDefinitionId(String var1);

        public Builder functions(Collection<Function> var1);

        public Builder functions(Function ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

