/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.ConnectivityInfo;

@SdkInternalApi
public class ConnectivityInfoMarshaller {
    private static final MarshallingInfo<String> HOSTADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HostAddress").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<String> METADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Metadata").build();
    private static final MarshallingInfo<Integer> PORTNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PortNumber").build();
    private static final ConnectivityInfoMarshaller INSTANCE = new ConnectivityInfoMarshaller();

    public static ConnectivityInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConnectivityInfo connectivityInfo, ProtocolMarshaller protocolMarshaller) {
        if (connectivityInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)connectivityInfo.hostAddress(), HOSTADDRESS_BINDING);
            protocolMarshaller.marshall((Object)connectivityInfo.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)connectivityInfo.metadata(), METADATA_BINDING);
            protocolMarshaller.marshall((Object)connectivityInfo.portNumber(), PORTNUMBER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

