/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.greengrass.model.DeploymentType;
import software.amazon.awssdk.services.greengrass.model.ErrorDetail;
import software.amazon.awssdk.services.greengrass.model.ErrorDetailsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDeploymentStatusResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetDeploymentStatusResponse> {
    private final String deploymentStatus;
    private final String deploymentType;
    private final List<ErrorDetail> errorDetails;
    private final String errorMessage;
    private final String updatedAt;

    private GetDeploymentStatusResponse(BuilderImpl builder) {
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentType = builder.deploymentType;
        this.errorDetails = builder.errorDetails;
        this.errorMessage = builder.errorMessage;
        this.updatedAt = builder.updatedAt;
    }

    public String deploymentStatus() {
        return this.deploymentStatus;
    }

    public DeploymentType deploymentType() {
        return DeploymentType.fromValue(this.deploymentType);
    }

    public String deploymentTypeString() {
        return this.deploymentType;
    }

    public List<ErrorDetail> errorDetails() {
        return this.errorDetails;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentStatusResponse)) {
            return false;
        }
        GetDeploymentStatusResponse other = (GetDeploymentStatusResponse)((Object)obj);
        return Objects.equals(this.deploymentStatus(), other.deploymentStatus()) && Objects.equals(this.deploymentTypeString(), other.deploymentTypeString()) && Objects.equals(this.errorDetails(), other.errorDetails()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deploymentStatus() != null) {
            sb.append("DeploymentStatus: ").append(this.deploymentStatus()).append(",");
        }
        if (this.deploymentTypeString() != null) {
            sb.append("DeploymentType: ").append(this.deploymentTypeString()).append(",");
        }
        if (this.errorDetails() != null) {
            sb.append("ErrorDetails: ").append(this.errorDetails()).append(",");
        }
        if (this.errorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.errorMessage()).append(",");
        }
        if (this.updatedAt() != null) {
            sb.append("UpdatedAt: ").append(this.updatedAt()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeploymentStatus": {
                return Optional.of(clazz.cast(this.deploymentStatus()));
            }
            case "DeploymentType": {
                return Optional.of(clazz.cast(this.deploymentTypeString()));
            }
            case "ErrorDetails": {
                return Optional.of(clazz.cast(this.errorDetails()));
            }
            case "ErrorMessage": {
                return Optional.of(clazz.cast(this.errorMessage()));
            }
            case "UpdatedAt": {
                return Optional.of(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentStatus;
        private String deploymentType;
        private List<ErrorDetail> errorDetails;
        private String errorMessage;
        private String updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentStatusResponse model) {
            this.deploymentStatus(model.deploymentStatus);
            this.deploymentType(model.deploymentType);
            this.errorDetails(model.errorDetails);
            this.errorMessage(model.errorMessage);
            this.updatedAt(model.updatedAt);
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType.toString());
            return this;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        public final Collection<ErrorDetail.Builder> getErrorDetails() {
            return this.errorDetails != null ? (Collection)this.errorDetails.stream().map(ErrorDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errorDetails(Collection<ErrorDetail> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copy(errorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(ErrorDetail ... errorDetails) {
            this.errorDetails(Arrays.asList(errorDetails));
            return this;
        }

        public final void setErrorDetails(Collection<ErrorDetail.BuilderImpl> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copyFromBuilder(errorDetails);
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        public GetDeploymentStatusResponse build() {
            return new GetDeploymentStatusResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetDeploymentStatusResponse> {
        public Builder deploymentStatus(String var1);

        public Builder deploymentType(String var1);

        public Builder deploymentType(DeploymentType var1);

        public Builder errorDetails(Collection<ErrorDetail> var1);

        public Builder errorDetails(ErrorDetail ... var1);

        public Builder errorMessage(String var1);

        public Builder updatedAt(String var1);
    }
}

