/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.greengrass.model.ListOfVersionInformationCopier;
import software.amazon.awssdk.services.greengrass.model.VersionInformation;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListLoggerDefinitionVersionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListLoggerDefinitionVersionsResponse> {
    private final String nextToken;
    private final List<VersionInformation> versions;

    private ListLoggerDefinitionVersionsResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.versions = builder.versions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<VersionInformation> versions() {
        return this.versions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.versions() == null ? 0 : this.versions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLoggerDefinitionVersionsResponse)) {
            return false;
        }
        ListLoggerDefinitionVersionsResponse other = (ListLoggerDefinitionVersionsResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.versions() == null ^ this.versions() == null) {
            return false;
        }
        return other.versions() == null || other.versions().equals(this.versions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.versions() != null) {
            sb.append("Versions: ").append(this.versions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "Versions": {
                return Optional.of(clazz.cast(this.versions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VersionInformation> versions;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLoggerDefinitionVersionsResponse model) {
            this.nextToken(model.nextToken);
            this.versions(model.versions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VersionInformation.Builder> getVersions() {
            return this.versions != null ? (Collection)this.versions.stream().map(VersionInformation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder versions(Collection<VersionInformation> versions) {
            this.versions = ListOfVersionInformationCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(VersionInformation ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        public final void setVersions(Collection<VersionInformation.BuilderImpl> versions) {
            this.versions = ListOfVersionInformationCopier.copyFromBuilder(versions);
        }

        public ListLoggerDefinitionVersionsResponse build() {
            return new ListLoggerDefinitionVersionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListLoggerDefinitionVersionsResponse> {
        public Builder nextToken(String var1);

        public Builder versions(Collection<VersionInformation> var1);

        public Builder versions(VersionInformation ... var1);
    }
}

