/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetGroupVersionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetGroupVersionRequest> {
    private final String groupId;
    private final String groupVersionId;

    private GetGroupVersionRequest(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.groupVersionId = builder.groupVersionId;
    }

    public String groupId() {
        return this.groupId;
    }

    public String groupVersionId() {
        return this.groupVersionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.groupId() == null ? 0 : this.groupId().hashCode());
        hashCode = 31 * hashCode + (this.groupVersionId() == null ? 0 : this.groupVersionId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupVersionRequest)) {
            return false;
        }
        GetGroupVersionRequest other = (GetGroupVersionRequest)((Object)obj);
        if (other.groupId() == null ^ this.groupId() == null) {
            return false;
        }
        if (other.groupId() != null && !other.groupId().equals(this.groupId())) {
            return false;
        }
        if (other.groupVersionId() == null ^ this.groupVersionId() == null) {
            return false;
        }
        return other.groupVersionId() == null || other.groupVersionId().equals(this.groupVersionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.groupId() != null) {
            sb.append("GroupId: ").append(this.groupId()).append(",");
        }
        if (this.groupVersionId() != null) {
            sb.append("GroupVersionId: ").append(this.groupVersionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupId": {
                return Optional.of(clazz.cast(this.groupId()));
            }
            case "GroupVersionId": {
                return Optional.of(clazz.cast(this.groupVersionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String groupId;
        private String groupVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGroupVersionRequest model) {
            this.groupId(model.groupId);
            this.groupVersionId(model.groupVersionId);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getGroupVersionId() {
            return this.groupVersionId;
        }

        @Override
        public final Builder groupVersionId(String groupVersionId) {
            this.groupVersionId = groupVersionId;
            return this;
        }

        public final void setGroupVersionId(String groupVersionId) {
            this.groupVersionId = groupVersionId;
        }

        public GetGroupVersionRequest build() {
            return new GetGroupVersionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetGroupVersionRequest> {
        public Builder groupId(String var1);

        public Builder groupVersionId(String var1);
    }
}

