/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.FunctionConfiguration;
import software.amazon.awssdk.services.greengrass.transform.FunctionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Function
implements StructuredPojo,
ToCopyableBuilder<Builder, Function> {
    private final String functionArn;
    private final FunctionConfiguration functionConfiguration;
    private final String id;

    private Function(BuilderImpl builder) {
        this.functionArn = builder.functionArn;
        this.functionConfiguration = builder.functionConfiguration;
        this.id = builder.id;
    }

    public String functionArn() {
        return this.functionArn;
    }

    public FunctionConfiguration functionConfiguration() {
        return this.functionConfiguration;
    }

    public String id() {
        return this.id;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.functionArn() == null ? 0 : this.functionArn().hashCode());
        hashCode = 31 * hashCode + (this.functionConfiguration() == null ? 0 : this.functionConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Function)) {
            return false;
        }
        Function other = (Function)obj;
        if (other.functionArn() == null ^ this.functionArn() == null) {
            return false;
        }
        if (other.functionArn() != null && !other.functionArn().equals(this.functionArn())) {
            return false;
        }
        if (other.functionConfiguration() == null ^ this.functionConfiguration() == null) {
            return false;
        }
        if (other.functionConfiguration() != null && !other.functionConfiguration().equals(this.functionConfiguration())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        return other.id() == null || other.id().equals(this.id());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.functionArn() != null) {
            sb.append("FunctionArn: ").append(this.functionArn()).append(",");
        }
        if (this.functionConfiguration() != null) {
            sb.append("FunctionConfiguration: ").append(this.functionConfiguration()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionArn": {
                return Optional.of(clazz.cast(this.functionArn()));
            }
            case "FunctionConfiguration": {
                return Optional.of(clazz.cast(this.functionConfiguration()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FunctionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String functionArn;
        private FunctionConfiguration functionConfiguration;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(Function model) {
            this.functionArn(model.functionArn);
            this.functionConfiguration(model.functionConfiguration);
            this.id(model.id);
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        public final FunctionConfiguration.Builder getFunctionConfiguration() {
            return this.functionConfiguration != null ? this.functionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder functionConfiguration(FunctionConfiguration functionConfiguration) {
            this.functionConfiguration = functionConfiguration;
            return this;
        }

        public final void setFunctionConfiguration(FunctionConfiguration.BuilderImpl functionConfiguration) {
            this.functionConfiguration = functionConfiguration != null ? functionConfiguration.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public Function build() {
            return new Function(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Function> {
        public Builder functionArn(String var1);

        public Builder functionConfiguration(FunctionConfiguration var1);

        public Builder id(String var1);
    }
}

