/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.greengrass.model.Core;
import software.amazon.awssdk.services.greengrass.model.ListOfCoreCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateCoreDefinitionVersionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateCoreDefinitionVersionRequest> {
    private final String amznClientToken;
    private final String coreDefinitionId;
    private final List<Core> cores;

    private CreateCoreDefinitionVersionRequest(BuilderImpl builder) {
        this.amznClientToken = builder.amznClientToken;
        this.coreDefinitionId = builder.coreDefinitionId;
        this.cores = builder.cores;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public String coreDefinitionId() {
        return this.coreDefinitionId;
    }

    public List<Core> cores() {
        return this.cores;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.amznClientToken() == null ? 0 : this.amznClientToken().hashCode());
        hashCode = 31 * hashCode + (this.coreDefinitionId() == null ? 0 : this.coreDefinitionId().hashCode());
        hashCode = 31 * hashCode + (this.cores() == null ? 0 : this.cores().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCoreDefinitionVersionRequest)) {
            return false;
        }
        CreateCoreDefinitionVersionRequest other = (CreateCoreDefinitionVersionRequest)((Object)obj);
        if (other.amznClientToken() == null ^ this.amznClientToken() == null) {
            return false;
        }
        if (other.amznClientToken() != null && !other.amznClientToken().equals(this.amznClientToken())) {
            return false;
        }
        if (other.coreDefinitionId() == null ^ this.coreDefinitionId() == null) {
            return false;
        }
        if (other.coreDefinitionId() != null && !other.coreDefinitionId().equals(this.coreDefinitionId())) {
            return false;
        }
        if (other.cores() == null ^ this.cores() == null) {
            return false;
        }
        return other.cores() == null || other.cores().equals(this.cores());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.amznClientToken() != null) {
            sb.append("AmznClientToken: ").append(this.amznClientToken()).append(",");
        }
        if (this.coreDefinitionId() != null) {
            sb.append("CoreDefinitionId: ").append(this.coreDefinitionId()).append(",");
        }
        if (this.cores() != null) {
            sb.append("Cores: ").append(this.cores()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.of(clazz.cast(this.amznClientToken()));
            }
            case "CoreDefinitionId": {
                return Optional.of(clazz.cast(this.coreDefinitionId()));
            }
            case "Cores": {
                return Optional.of(clazz.cast(this.cores()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String amznClientToken;
        private String coreDefinitionId;
        private List<Core> cores;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCoreDefinitionVersionRequest model) {
            this.amznClientToken(model.amznClientToken);
            this.coreDefinitionId(model.coreDefinitionId);
            this.cores(model.cores);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getCoreDefinitionId() {
            return this.coreDefinitionId;
        }

        @Override
        public final Builder coreDefinitionId(String coreDefinitionId) {
            this.coreDefinitionId = coreDefinitionId;
            return this;
        }

        public final void setCoreDefinitionId(String coreDefinitionId) {
            this.coreDefinitionId = coreDefinitionId;
        }

        public final Collection<Core.Builder> getCores() {
            return this.cores != null ? (Collection)this.cores.stream().map(Core::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cores(Collection<Core> cores) {
            this.cores = ListOfCoreCopier.copy(cores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cores(Core ... cores) {
            this.cores(Arrays.asList(cores));
            return this;
        }

        public final void setCores(Collection<Core.BuilderImpl> cores) {
            this.cores = ListOfCoreCopier.copyFromBuilder(cores);
        }

        public CreateCoreDefinitionVersionRequest build() {
            return new CreateCoreDefinitionVersionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateCoreDefinitionVersionRequest> {
        public Builder amznClientToken(String var1);

        public Builder coreDefinitionId(String var1);

        public Builder cores(Collection<Core> var1);

        public Builder cores(Core ... var1);
    }
}

