/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.DeviceDefinitionVersion;

@SdkInternalApi
public class DeviceDefinitionVersionMarshaller {
    private static final MarshallingInfo<List> DEVICES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Devices").build();
    private static final DeviceDefinitionVersionMarshaller INSTANCE = new DeviceDefinitionVersionMarshaller();

    public static DeviceDefinitionVersionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeviceDefinitionVersion deviceDefinitionVersion, ProtocolMarshaller protocolMarshaller) {
        if (deviceDefinitionVersion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(deviceDefinitionVersion.devices(), DEVICES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

