/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum LoggerLevel {
    DEBUG("DEBUG"),
    INFO("INFO"),
    WARN("WARN"),
    ERROR("ERROR"),
    FATAL("FATAL");

    private final String value;

    private LoggerLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static LoggerLevel fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(LoggerLevel.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

